/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.Analysis;

public class NoriTokenizerFactory
extends AbstractTokenizerFactory {
    private static final String USER_DICT_OPTION = "user_dictionary";
    private final UserDictionary userDictionary;
    private final KoreanTokenizer.DecompoundMode decompoundMode;

    public NoriTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.decompoundMode = NoriTokenizerFactory.getMode(settings);
        this.userDictionary = NoriTokenizerFactory.getUserDictionary(env, settings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UserDictionary getUserDictionary(Environment env, Settings settings) {
        try (Reader reader = Analysis.getReaderFromFile((Environment)env, (Settings)settings, (String)USER_DICT_OPTION);){
            if (reader == null) {
                UserDictionary userDictionary = null;
                return userDictionary;
            }
            UserDictionary userDictionary = UserDictionary.open((Reader)reader);
            return userDictionary;
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to load nori user dictionary", (Throwable)e, new Object[0]);
        }
    }

    public static KoreanTokenizer.DecompoundMode getMode(Settings settings) {
        KoreanTokenizer.DecompoundMode mode = KoreanTokenizer.DEFAULT_DECOMPOUND;
        String modeSetting = settings.get("decompound_mode", null);
        if (modeSetting != null) {
            mode = KoreanTokenizer.DecompoundMode.valueOf((String)modeSetting.toUpperCase(Locale.ENGLISH));
        }
        return mode;
    }

    public Tokenizer create() {
        return new KoreanTokenizer(KoreanTokenizer.DEFAULT_TOKEN_ATTRIBUTE_FACTORY, this.userDictionary, this.decompoundMode, false);
    }
}

