/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseReadingFormFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class KuromojiReadingFormFilterFactory
extends AbstractTokenFilterFactory {
    private final boolean useRomaji;

    public KuromojiReadingFormFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name);
        this.useRomaji = settings.getAsBoolean("use_romaji", Boolean.valueOf(false));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapaneseReadingFormFilter(tokenStream, this.useRomaji);
    }
}

