/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.search.suggest.analyzing.SuggestStopFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.Analysis;

public class JapaneseStopTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final Map<String, Set<?>> NAMED_STOP_WORDS = Collections.singletonMap("_japanese_", JapaneseAnalyzer.getDefaultStopSet());
    private final CharArraySet stopWords;
    private final boolean ignoreCase;
    private final boolean removeTrailing;

    public JapaneseStopTokenFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name);
        this.ignoreCase = settings.getAsBoolean("ignore_case", Boolean.valueOf(false));
        this.removeTrailing = settings.getAsBoolean("remove_trailing", Boolean.valueOf(true));
        this.stopWords = Analysis.parseWords((Environment)env, (Settings)settings, (String)"stopwords", (CharArraySet)JapaneseAnalyzer.getDefaultStopSet(), NAMED_STOP_WORDS, (boolean)this.ignoreCase);
    }

    public TokenStream create(TokenStream tokenStream) {
        if (this.removeTrailing) {
            return new StopFilter(tokenStream, this.stopWords);
        }
        return new SuggestStopFilter(tokenStream, this.stopWords);
    }

    public Set<?> stopWords() {
        return this.stopWords;
    }

    public boolean ignoreCase() {
        return this.ignoreCase;
    }
}

