/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseCompletionFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class KuromojiCompletionFilterFactory
extends AbstractTokenFilterFactory {
    private final JapaneseCompletionFilter.Mode mode;

    public KuromojiCompletionFilterFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.mode = KuromojiCompletionFilterFactory.getMode(settings);
    }

    public static JapaneseCompletionFilter.Mode getMode(Settings settings) {
        JapaneseCompletionFilter.Mode mode = JapaneseCompletionFilter.Mode.INDEX;
        String modeSetting = settings.get("mode", null);
        if (modeSetting != null) {
            if ("index".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseCompletionFilter.Mode.INDEX;
            } else if ("query".equalsIgnoreCase(modeSetting)) {
                mode = JapaneseCompletionFilter.Mode.QUERY;
            }
        }
        return mode;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new JapaneseCompletionFilter(tokenStream, this.mode);
    }
}

