/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.kuromoji;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugin.analysis.kuromoji.JapaneseStopTokenFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiAnalyzerProvider;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiBaseFormFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiCompletionAnalyzerProvider;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiCompletionFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiIterationMarkCharFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiKatakanaStemmerFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiNumberFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiPartOfSpeechFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiReadingFormFilterFactory;
import org.elasticsearch.plugin.analysis.kuromoji.KuromojiTokenizerFactory;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;

public class AnalysisKuromojiPlugin
extends Plugin
implements AnalysisPlugin {
    public Map<String, AnalysisModule.AnalysisProvider<CharFilterFactory>> getCharFilters() {
        return Collections.singletonMap("kuromoji_iteration_mark", KuromojiIterationMarkCharFilterFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>>();
        extra.put("kuromoji_baseform", KuromojiBaseFormFilterFactory::new);
        extra.put("kuromoji_part_of_speech", KuromojiPartOfSpeechFilterFactory::new);
        extra.put("kuromoji_readingform", KuromojiReadingFormFilterFactory::new);
        extra.put("kuromoji_stemmer", KuromojiKatakanaStemmerFactory::new);
        extra.put("ja_stop", JapaneseStopTokenFilterFactory::new);
        extra.put("kuromoji_number", KuromojiNumberFilterFactory::new);
        extra.put("kuromoji_completion", KuromojiCompletionFilterFactory::new);
        return extra;
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap("kuromoji_tokenizer", KuromojiTokenizerFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        HashMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> extra = new HashMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>>();
        extra.put("kuromoji", KuromojiAnalyzerProvider::new);
        extra.put("kuromoji_completion", KuromojiCompletionAnalyzerProvider::new);
        return extra;
    }
}

