/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.icu;

import com.ibm.icu.text.Normalizer2;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.icu.ICUNormalizer2CharFilter;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.plugin.analysis.icu.IcuNormalizerTokenFilterFactory;

public class IcuAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final Normalizer2 normalizer;

    public IcuAnalyzerProvider(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name);
        String method = settings.get("method", "nfkc_cf");
        String mode = settings.get("mode", "compose");
        if (!"compose".equals(mode) && !"decompose".equals(mode)) {
            throw new IllegalArgumentException("Unknown mode [" + mode + "] in analyzer [" + name + "], expected one of [compose, decompose]");
        }
        Normalizer2 normalizerInstance = Normalizer2.getInstance(null, (String)method, (Normalizer2.Mode)("compose".equals(mode) ? Normalizer2.Mode.COMPOSE : Normalizer2.Mode.DECOMPOSE));
        this.normalizer = IcuNormalizerTokenFilterFactory.wrapWithUnicodeSetFilter(normalizerInstance, settings);
    }

    public Analyzer get() {
        return new Analyzer(){

            protected Reader initReader(String fieldName, Reader reader) {
                return new ICUNormalizer2CharFilter(reader, IcuAnalyzerProvider.this.normalizer);
            }

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                ICUTokenizer source = new ICUTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)new ICUFoldingFilter((TokenStream)source));
            }
        };
    }
}

