/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.icu;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import org.apache.lucene.analysis.TokenStream;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.plugin.analysis.icu.ICUCollationKeyFilter;

public class IcuCollationTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Collator collator;

    public IcuCollationTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name, settings);
        Boolean hiraganaQuaternaryMode;
        String variableTop;
        Boolean numeric;
        String caseFirst;
        Boolean caseLevel;
        String decomposition;
        Collator collator;
        String rules = settings.get("rules");
        if (rules != null) {
            Exception failureToResolve = null;
            try {
                rules = Streams.copyToString((Reader)Files.newBufferedReader(environment.configDir().resolve(rules), StandardCharsets.UTF_8));
            }
            catch (IOException | SecurityException | InvalidPathException e) {
                failureToResolve = e;
            }
            try {
                collator = new RuleBasedCollator(rules);
            }
            catch (Exception e) {
                if (failureToResolve != null) {
                    throw new IllegalArgumentException("Failed to resolve collation rules location", failureToResolve);
                }
                throw new IllegalArgumentException("Failed to parse collation rules", e);
            }
        }
        String language = settings.get("language");
        if (language != null) {
            String variant;
            String country = settings.get("country");
            ULocale locale = country != null ? ((variant = settings.get("variant")) != null ? new ULocale(language, country, variant) : new ULocale(language, country)) : new ULocale(language);
            collator = Collator.getInstance((ULocale)locale);
        } else {
            collator = Collator.getInstance((ULocale)ULocale.ROOT);
        }
        String strength = settings.get("strength");
        if (strength != null) {
            if (strength.equalsIgnoreCase("primary")) {
                collator.setStrength(0);
            } else if (strength.equalsIgnoreCase("secondary")) {
                collator.setStrength(1);
            } else if (strength.equalsIgnoreCase("tertiary")) {
                collator.setStrength(2);
            } else if (strength.equalsIgnoreCase("quaternary")) {
                collator.setStrength(3);
            } else if (strength.equalsIgnoreCase("identical")) {
                collator.setStrength(15);
            } else {
                throw new IllegalArgumentException("Invalid strength: " + strength);
            }
        }
        if ((decomposition = settings.get("decomposition")) != null) {
            if (decomposition.equalsIgnoreCase("no")) {
                collator.setDecomposition(16);
            } else if (decomposition.equalsIgnoreCase("canonical")) {
                collator.setDecomposition(17);
            } else {
                throw new IllegalArgumentException("Invalid decomposition: " + decomposition);
            }
        }
        RuleBasedCollator rbc = (RuleBasedCollator)collator;
        String alternate = settings.get("alternate");
        if (alternate != null) {
            if (alternate.equalsIgnoreCase("shifted")) {
                rbc.setAlternateHandlingShifted(true);
            } else if (alternate.equalsIgnoreCase("non-ignorable")) {
                rbc.setAlternateHandlingShifted(false);
            } else {
                throw new IllegalArgumentException("Invalid alternate: " + alternate);
            }
        }
        if ((caseLevel = settings.getAsBoolean("caseLevel", null)) != null) {
            rbc.setCaseLevel(caseLevel.booleanValue());
        }
        if ((caseFirst = settings.get("caseFirst")) != null) {
            if (caseFirst.equalsIgnoreCase("lower")) {
                rbc.setLowerCaseFirst(true);
            } else if (caseFirst.equalsIgnoreCase("upper")) {
                rbc.setUpperCaseFirst(true);
            } else {
                throw new IllegalArgumentException("Invalid caseFirst: " + caseFirst);
            }
        }
        if ((numeric = settings.getAsBoolean("numeric", null)) != null) {
            rbc.setNumericCollation(numeric.booleanValue());
        }
        if ((variableTop = settings.get("variableTop")) != null) {
            rbc.setVariableTop(variableTop);
        }
        if ((hiraganaQuaternaryMode = settings.getAsBoolean("hiraganaQuaternaryMode", null)) != null) {
            rbc.setHiraganaQuaternary(hiraganaQuaternaryMode.booleanValue());
        }
        this.collator = collator;
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUCollationKeyFilter(tokenStream, this.collator);
    }
}

