/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.icu;

import com.ibm.icu.text.Transliterator;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.NormalizingTokenFilterFactory;

public class IcuTransformTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private final String id;
    private final int dir;
    private final Transliterator transliterator;

    public IcuTransformTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name, settings);
        this.id = settings.get("id", "Null");
        String s = settings.get("dir", "forward");
        this.dir = "forward".equals(s) ? 0 : 1;
        this.transliterator = Transliterator.getInstance((String)this.id, (int)this.dir);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUTransformFilter(tokenStream, this.transliterator);
    }
}

