/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.Transliterator;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUTransformFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class ICUTransformFilterFactory
extends TokenFilterFactory {
    private final Transliterator transliterator;

    public ICUTransformFilterFactory(Map<String, String> args) {
        super(args);
        String id = this.require(args, "id");
        String direction = this.get(args, "direction", Arrays.asList("forward", "reverse"), "forward", false);
        int dir = "forward".equals(direction) ? 0 : 1;
        this.transliterator = Transliterator.getInstance((String)id, (int)dir);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public TokenStream create(TokenStream input) {
        return new ICUTransformFilter(input, this.transliterator);
    }

    public TokenStream normalize(TokenStream input) {
        return this.create(input);
    }
}

