/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.icu.segmentation.DefaultICUTokenizerConfig;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizer;
import org.apache.lucene.analysis.icu.segmentation.ICUTokenizerConfig;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;

public class IcuTokenizerFactory
extends AbstractTokenizerFactory {
    private final ICUTokenizerConfig config;
    private static final String RULE_FILES = "rule_files";

    public IcuTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.config = this.getIcuConfig(environment, settings);
    }

    public Tokenizer create() {
        if (this.config == null) {
            return new ICUTokenizer();
        }
        return new ICUTokenizer(this.config);
    }

    private ICUTokenizerConfig getIcuConfig(Environment env, Settings settings) {
        HashMap<Integer, String> tailored = new HashMap<Integer, String>();
        try {
            String resourcePath;
            List ruleFiles = settings.getAsList(RULE_FILES);
            for (Object scriptAndResourcePath : ruleFiles) {
                int n = ((String)scriptAndResourcePath).indexOf(":");
                if (n == -1 || n == ((String)scriptAndResourcePath).length() - 1) {
                    throw new IllegalArgumentException("rule_files should contain comma-separated \"code:rulefile\" pairs");
                }
                String scriptCode = ((String)scriptAndResourcePath).substring(0, n).trim();
                resourcePath = ((String)scriptAndResourcePath).substring(n + 1).trim();
                tailored.put(UCharacter.getPropertyValueEnum((int)4106, (CharSequence)scriptCode), resourcePath);
            }
            if (tailored.isEmpty()) {
                return null;
            }
            final RuleBasedBreakIterator[] breakers = new RuleBasedBreakIterator[185];
            for (Map.Entry entry : tailored.entrySet()) {
                int code = (Integer)entry.getKey();
                resourcePath = (String)entry.getValue();
                breakers[code] = this.parseRules(resourcePath, env);
            }
            DefaultICUTokenizerConfig config = new DefaultICUTokenizerConfig(true, true){

                public RuleBasedBreakIterator getBreakIterator(int script) {
                    if (breakers[script] != null) {
                        return (RuleBasedBreakIterator)breakers[script].clone();
                    }
                    return super.getBreakIterator(script);
                }
            };
            return config;
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load ICU rule files", (Throwable)e, new Object[0]);
        }
    }

    private RuleBasedBreakIterator parseRules(String filename, Environment env) throws IOException {
        Path path = env.configFile().resolve(filename);
        String rules = Files.readAllLines(path).stream().filter(v -> !v.startsWith("#")).collect(Collectors.joining("\n"));
        return new RuleBasedBreakIterator(rules.toString());
    }
}

