# delete service if it already exists
if (Get-Service packetbeat -ErrorAction SilentlyContinue) {
  $service = Get-WmiObject -Class Win32_Service -Filter "name='packetbeat'"
  $service.StopService()
  Start-Sleep -s 1
  $service.delete()
}

$workdir = Split-Path $MyInvocation.MyCommand.Path

# create new service
New-Service -name packetbeat `
  -displayName packetbeat `
  -binaryPathName "`"$workdir\\packetbeat.exe`" -c `"$workdir\\packetbeat.yml`" -path.home `"$workdir`" -path.data `"C:\\ProgramData\\packetbeat`""
