package compliance.cis_aws.rules.cis_3_6

import data.compliance.lib.common
import data.compliance.policy.aws_cloudtrail.data_adapter

default rule_evaluation = false

# Ensure S3 bucket access logging is enabled on the CloudTrail S3 bucket
finding = result {
	# filter
	data_adapter.is_single_trail

	# set result
	result := common.generate_result_without_expected(
		common.calculate_result(rule_evaluation),
		input.resource,
	)
}

rule_evaluation {
	data_adapter.trail_bucket_info.logging.enabled == true
}
