# Delete and stop the service if it already exists.
if (Get-Service metricbeat -ErrorAction SilentlyContinue) {
  Stop-Service metricbeat
  (Get-Service metricbeat).WaitForStatus('Stopped')
  Start-Sleep -s 1
  sc.exe delete metricbeat
}

$workdir = Split-Path $MyInvocation.MyCommand.Path

# Create the new service.
New-Service -name metricbeat `
  -displayName Metricbeat `
  -binaryPathName "`"$workdir\metricbeat.exe`" --environment=windows_service -c `"$workdir\metricbeat.yml`" --path.home `"$workdir`" --path.data `"$env:PROGRAMDATA\metricbeat`" --path.logs `"$env:PROGRAMDATA\metricbeat\logs`" -E logging.files.redirect_stderr=true"

# Attempt to set the service to delayed start using sc config.
Try {
  Start-Process -FilePath sc.exe -ArgumentList 'config metricbeat start= delayed-auto'
}
Catch { Write-Host -f red "An error occurred setting the service to delayed start." }
