package compliance.cis_k8s.rules.cis_4_2_2

import data.compliance.policy.process.ensure_arguments_and_config as audit

# Ensure that the --authorization-mode argument is not set to AlwaysAllow (Automated)
# If the --authorization-mode argument is present check that it is not set to AlwaysAllow.
default rule_evaluation = false

rule_evaluation {
	is_authorization_allow_all
}

is_authorization_allow_all {
	audit.process_arg_not_key_value("--authorization-mode", "--authorization-mode", "AlwaysAllow")
}

# In case both flags and configuration file are specified, the executable argument takes precedence.
# Checks that the entry for authorization:mode is not set to AlwaysAllow.
rule_evaluation {
	not is_authorization_allow_all
	audit.process_filter_variable_multi_comparison(["authorization", "mode"], ["authorization", "mode"], "AlwaysAllow")
}

finding = audit.finding(rule_evaluation)
