$ErrorActionPreference = "Stop"

# Delete and stop the service if it already exists.
if (Get-Service elastic-agent -ErrorAction SilentlyContinue) {
  $service = Get-WmiObject -Class Win32_Service -Filter "name='elastic-agent'"
  $service.StopService()
  Start-Sleep -s 1
  $service.delete()
}

$workdir = Split-Path $MyInvocation.MyCommand.Path

# Create the new service.
New-Service -name elastic-agent `
  -displayName Elastic-Agent `
  -binaryPathName "`"$workdir\elastic-agent.exe`" --path.home `"$workdir`" --path.data  `"$workdir\data`" run"

# Start the new service.
Start-Service -name elastic-agent
