/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.attach;

import co.elastic.apm.agent.common.util.Version;
import co.elastic.apm.attach.AgentDownloadUtils;
import co.elastic.apm.attach.PgpSignatureVerifier;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AgentDownloader {
    private static final Pattern VERSION_EXTRACTION_REGEX = Pattern.compile("<version>(.+?)</version>");
    private static final String AGENT_GROUP_ID = "co.elastic.apm";
    private static final String AGENT_ARTIFACT_ID = "elastic-apm-agent";
    private static final String CLI_JAR_VERSION = AgentDownloader.readCliJarVersion();
    public static final String USER_AGENT;
    private final Map<String, byte[]> keys;
    private final Logger logger = LogManager.getLogger(AgentDownloader.class);
    private final PgpSignatureVerifier pgpSignatureVerifier;

    private static String readCliJarVersion() {
        String pomPropertiesLocation = "/META-INF/maven/co.elastic.apm/apm-agent-attach-cli/pom.properties";
        Properties pomProperties = null;
        try (InputStream pomPropertiesStream = AgentDownloader.class.getResourceAsStream(pomPropertiesLocation);){
            if (pomPropertiesStream != null) {
                pomProperties = new Properties();
                pomProperties.load(pomPropertiesStream);
            }
        }
        catch (Exception exception) {
            pomProperties = null;
        }
        if (pomProperties != null) {
            return pomProperties.getProperty("version");
        }
        return null;
    }

    public static String getCliJarVersion() {
        return CLI_JAR_VERSION;
    }

    public AgentDownloader(PgpSignatureVerifier pgpSignatureVerifier) {
        this.pgpSignatureVerifier = pgpSignatureVerifier;
        this.keys = new HashMap<String, byte[]>();
        this.keys.put("D27D666CD88E42B4", AgentDownloader.getPubKeyContent("/pub_key_D27D666CD88E42B4.asc", 1780));
        this.keys.put("8AB554FD8F207067", AgentDownloader.getPubKeyContent("/pub_key_8AB554FD8F207067.asc", 977));
    }

    Path downloadAndVerifyAgent(String agentVersion) throws Exception {
        this.logger.debug("Requested to download Elastic APM Java agent version {}", (Object)agentVersion);
        String mavenAgentBaseUrl = this.getAgentMavenVersionBaseUrl(agentVersion);
        Path targetDir = AgentDownloadUtils.of(agentVersion).getTargetAgentDir();
        String agentJarName = this.computeAgentJarName(agentVersion);
        String mavenAgentJarUrl = this.computeFileUrl(mavenAgentBaseUrl, agentJarName);
        Path localAgentJarPath = targetDir.resolve(agentJarName);
        boolean downloadAndVerify = true;
        if (Files.exists(localAgentJarPath, new LinkOption[0])) {
            this.logger.debug("{} already exists at {}", (Object)agentJarName, (Object)targetDir);
            if (Files.isReadable(localAgentJarPath)) {
                downloadAndVerify = false;
            } else {
                this.logger.info("{} is not readable for the current user, removing and downloading again", (Object)localAgentJarPath);
                Files.delete(localAgentJarPath);
            }
        }
        if (downloadAndVerify) {
            this.downloadFile(mavenAgentJarUrl, localAgentJarPath);
            try {
                this.verifyPgpSignature(localAgentJarPath, mavenAgentJarUrl);
            }
            catch (Throwable throwable) {
                if (Files.exists(localAgentJarPath, new LinkOption[0])) {
                    Files.delete(localAgentJarPath);
                }
                throw throwable;
            }
        }
        return localAgentJarPath;
    }

    String computeFileUrl(String mavenArtifactBaseUrl, String artifactFileName) {
        return String.format(Locale.ROOT, "%s/%s", mavenArtifactBaseUrl, artifactFileName);
    }

    String computeAgentJarName(String agentVersion) {
        return String.format(Locale.ROOT, "%s-%s.jar", AGENT_ARTIFACT_ID, agentVersion);
    }

    String getAgentMavenVersionBaseUrl(String agentVersion) throws Exception {
        String agentMavenUrl = String.format("%s/%s", AgentDownloader.getAgentArtifactMavenBaseUrl(), agentVersion);
        if (!AgentDownloader.verifyUrl(agentMavenUrl)) {
            throw new IllegalArgumentException(String.format("Cannot find maven URL for version %s, make sure provided version is valid", agentVersion));
        }
        return agentMavenUrl;
    }

    static String getAgentArtifactMavenBaseUrl() throws Exception {
        String groupId = AGENT_GROUP_ID.replace(".", "/");
        String agentMavenUrl = String.format("https://repo1.maven.org/maven2/%s/%s", groupId, AGENT_ARTIFACT_ID);
        if (!AgentDownloader.verifyUrl(agentMavenUrl)) {
            throw new IllegalArgumentException(String.format("Cannot find maven URL for agent artifact: %s:%s", groupId, AGENT_ARTIFACT_ID));
        }
        return agentMavenUrl;
    }

    private static boolean verifyUrl(String urlString) throws IOException {
        HttpURLConnection urlConnection = AgentDownloader.openConnection(urlString);
        urlConnection.setRequestMethod("HEAD");
        urlConnection.connect();
        return urlConnection.getResponseCode() == 200;
    }

    private static HttpURLConnection openConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.addRequestProperty("User-Agent", USER_AGENT);
        return urlConnection;
    }

    void downloadFile(String remoteFileUrlString, Path localFilePath) throws IOException {
        this.logger.info("Downloading file from {} to {}, this may take a few seconds...", (Object)remoteFileUrlString, (Object)localFilePath);
        HttpURLConnection jarConnection = AgentDownloader.openConnection(remoteFileUrlString);
        try (InputStream in = jarConnection.getInputStream();){
            Files.copy(in, localFilePath, new CopyOption[0]);
        }
        this.logger.info("File download completed successfully.");
    }

    void verifyPgpSignature(Path agentJarFile, String mavenAgentUrlString) throws Exception {
        byte[] signatureBytes;
        String ascUrlString = mavenAgentUrlString + ".asc";
        this.logger.info("Verifying Elastic APM Java Agent jar PGP signature...");
        HttpURLConnection signatureFileUrlConnection = AgentDownloader.openConnection(ascUrlString);
        int signatureLength = signatureFileUrlConnection.getContentLength();
        if (signatureLength <= 0) {
            throw new IllegalStateException("unexpected signature size");
        }
        try (InputStream inputStream = signatureFileUrlConnection.getInputStream();){
            signatureBytes = AgentDownloader.toByteArray(inputStream, signatureLength);
        }
        for (Map.Entry<String, byte[]> entry : this.getPublicKeys().entrySet()) {
            InputStream agentJarIS = Files.newInputStream(agentJarFile, new OpenOption[0]);
            try {
                block18: {
                    ByteArrayInputStream pgpSignatureIS = new ByteArrayInputStream(signatureBytes);
                    this.logger.debug("attempt to verify with key [{}]", (Object)entry.getKey());
                    ByteArrayInputStream publicKeyIS = new ByteArrayInputStream(entry.getValue());
                    if (!this.pgpSignatureVerifier.verifyPgpSignature(agentJarIS, pgpSignatureIS, publicKeyIS, entry.getKey())) break block18;
                    this.logger.info("Elastic APM Java Agent jar PGP signature successfully verified.");
                    return;
                }
                try {
                    this.logger.debug("key verification failed with key [{}]", (Object)entry.getKey());
                }
                catch (Exception e) {
                    this.logger.debug(e.getMessage());
                }
            }
            finally {
                if (agentJarIS == null) continue;
                agentJarIS.close();
            }
        }
        throw new IllegalStateException("Signature verification for " + mavenAgentUrlString + " failed, downloaded jar may have been tampered with.");
    }

    static String findLatestVersion() throws Exception {
        String agentArtifactMavenMetadatUrl = AgentDownloader.getAgentArtifactMavenBaseUrl() + "/maven-metadata.xml";
        HttpURLConnection httpURLConnection = AgentDownloader.openConnection(agentArtifactMavenMetadatUrl);
        TreeSet<Version> versions = AgentDownloader.parseMavenMetadataXml(httpURLConnection.getInputStream());
        if (versions.isEmpty()) {
            throw new IllegalStateException("Failed to parse agent versions from the contents of " + agentArtifactMavenMetadatUrl);
        }
        return versions.last().toString();
    }

    static TreeSet<Version> parseMavenMetadataXml(InputStream htmlInputStream) throws IOException {
        String line;
        TreeSet<Version> versions = new TreeSet<Version>();
        BufferedReader versionsHtmlReader = new BufferedReader(new InputStreamReader(htmlInputStream));
        while ((line = versionsHtmlReader.readLine()) != null) {
            try {
                Version version;
                Matcher matcher = VERSION_EXTRACTION_REGEX.matcher(line);
                if (!matcher.find() || (version = Version.of(matcher.group(1))).hasSuffix()) continue;
                versions.add(version);
            }
            catch (Exception exception) {}
        }
        return versions;
    }

    public Map<String, byte[]> getPublicKeys() {
        return this.keys;
    }

    private static byte[] getPubKeyContent(String path, int size) {
        byte[] byArray;
        block9: {
            InputStream inputStream = AgentDownloader.class.getResourceAsStream(path);
            try {
                if (inputStream == null) {
                    throw new IllegalStateException("unknown key file: " + path);
                }
                byArray = AgentDownloader.toByteArray(inputStream, size);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private static byte[] toByteArray(InputStream inputStream, int size) throws IOException {
        byte[] result = new byte[size];
        if (size == 0 || size != inputStream.read(result) || inputStream.read() >= 0) {
            throw new IllegalStateException("invalid input size" + size);
        }
        return result;
    }

    static {
        StringBuilder userAgent = new StringBuilder("elastic-apm-agent-java-attach-cli");
        if (CLI_JAR_VERSION != null) {
            userAgent.append("/").append(CLI_JAR_VERSION);
        }
        USER_AGENT = userAgent.toString();
    }
}

