# delete service if it already exists
if (Get-Service apm-server -ErrorAction SilentlyContinue) {
  $service = Get-WmiObject -Class Win32_Service -Filter "name='apm-server'"
  $service.StopService()
  Start-Sleep -s 1
  $service.delete()
}

$workdir = Split-Path $MyInvocation.MyCommand.Path

# create new service
New-Service -name apm-server `
  -displayName apm-server `
  -binaryPathName "`"$workdir\\apm-server.exe`" -c `"$workdir\\apm-server.yml`" -path.home `"$workdir`" -path.data `"C:\\ProgramData\\apm-server`" -path.logs `"C:\\ProgramData\\apm-server\logs`""
