/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.watch;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.actions.Action;
import org.elasticsearch.watcher.actions.ActionStatus;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.clock.SystemClock;
import org.elasticsearch.watcher.support.xcontent.WatcherXContentParser;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class WatchStatus
implements ToXContent,
Streamable {
    public static final String INCLUDE_VERSION_KEY = "include_version";
    private transient long version;
    private State state;
    @Nullable
    private DateTime lastChecked;
    @Nullable
    private DateTime lastMetCondition;
    private ImmutableMap<String, ActionStatus> actions;
    private volatile boolean dirty = false;

    private WatchStatus() {
    }

    public WatchStatus(DateTime now, ImmutableMap<String, ActionStatus> actions) {
        this(-1L, new State(true, now), null, null, actions);
    }

    public WatchStatus(WatchStatus other) {
        this(other.version, other.state, other.lastChecked, other.lastMetCondition, other.actions);
    }

    private WatchStatus(long version, State state, DateTime lastChecked, DateTime lastMetCondition, ImmutableMap<String, ActionStatus> actions) {
        this.version = version;
        this.lastChecked = lastChecked;
        this.lastMetCondition = lastMetCondition;
        this.actions = actions;
        this.state = state;
    }

    public State state() {
        return this.state;
    }

    public long version() {
        return this.version;
    }

    public void version(long version) {
        this.version = version;
    }

    public boolean checked() {
        return this.lastChecked != null;
    }

    public DateTime lastChecked() {
        return this.lastChecked;
    }

    public boolean metCondition() {
        return this.lastMetCondition != null;
    }

    public DateTime lastMetCondition() {
        return this.lastMetCondition;
    }

    public ActionStatus actionStatus(String actionId) {
        return (ActionStatus)this.actions.get((Object)actionId);
    }

    public void resetDirty() {
        this.dirty = false;
    }

    public boolean dirty() {
        return this.dirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchStatus that = (WatchStatus)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.lastChecked != null ? !this.lastChecked.equals((Object)that.lastChecked) : that.lastChecked != null) {
            return false;
        }
        if (this.lastMetCondition != null ? !this.lastMetCondition.equals((Object)that.lastMetCondition) : that.lastMetCondition != null) {
            return false;
        }
        return !(this.actions == null ? that.actions != null : !this.actions.equals(that.actions));
    }

    public int hashCode() {
        int result = (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.lastChecked != null ? this.lastChecked.hashCode() : 0);
        result = 31 * result + (this.lastMetCondition != null ? this.lastMetCondition.hashCode() : 0);
        result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
        return result;
    }

    public void onCheck(boolean metCondition, DateTime timestamp) {
        this.lastChecked = timestamp;
        if (metCondition) {
            this.lastMetCondition = timestamp;
            this.dirty = true;
        } else {
            for (ActionStatus status : this.actions.values()) {
                this.dirty |= status.resetAckStatus(timestamp);
            }
        }
    }

    public void onActionResult(String actionId, DateTime timestamp, Action.Result result) {
        ActionStatus status = (ActionStatus)this.actions.get((Object)actionId);
        status.update(timestamp, result);
        this.dirty = true;
    }

    boolean onAck(DateTime timestamp, String ... actionIds) {
        boolean changed = false;
        boolean containsAll = false;
        for (String actionId : actionIds) {
            if (!actionId.equals("_all")) continue;
            containsAll = true;
            break;
        }
        if (containsAll) {
            for (ActionStatus status : this.actions.values()) {
                changed |= status.onAck(timestamp);
            }
            this.dirty |= changed;
            return changed;
        }
        for (String actionId : actionIds) {
            ActionStatus status = (ActionStatus)this.actions.get((Object)actionId);
            if (status == null) continue;
            changed |= status.onAck(timestamp);
        }
        this.dirty |= changed;
        return changed;
    }

    boolean setActive(boolean active, DateTime now) {
        boolean change;
        boolean bl = change = this.state.active != active;
        if (change) {
            this.dirty = true;
            this.state = new State(active, now);
        }
        return change;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        WatcherDateTimeUtils.writeOptionalDate(out, this.lastChecked);
        WatcherDateTimeUtils.writeOptionalDate(out, this.lastMetCondition);
        out.writeInt(this.actions.size());
        for (Map.Entry entry : this.actions.entrySet()) {
            out.writeString((String)entry.getKey());
            ActionStatus.writeTo((ActionStatus)entry.getValue(), out);
        }
        if (out.getVersion().onOrAfter(Version.V_2_0_0)) {
            out.writeBoolean(this.state.active);
            WatcherDateTimeUtils.writeDate(out, this.state.timestamp);
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        this.version = in.readLong();
        this.lastChecked = WatcherDateTimeUtils.readOptionalDate(in, DateTimeZone.UTC);
        this.lastMetCondition = WatcherDateTimeUtils.readOptionalDate(in, DateTimeZone.UTC);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            builder.put((Object)in.readString(), (Object)ActionStatus.readFrom(in));
        }
        this.actions = builder.build();
        this.state = in.getVersion().onOrAfter(Version.V_2_0_0) ? new State(in.readBoolean(), WatcherDateTimeUtils.readDate(in, DateTimeZone.UTC)) : new State(true, new DateTime(SystemClock.INSTANCE.millis(), DateTimeZone.UTC));
    }

    public static WatchStatus read(StreamInput in) throws IOException {
        WatchStatus status = new WatchStatus();
        status.readFrom(in);
        return status;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean(INCLUDE_VERSION_KEY, false)) {
            builder.field(Field.VERSION.getPreferredName(), this.version);
        }
        builder.field(Field.STATE.getPreferredName(), (ToXContent)this.state, params);
        if (this.lastChecked != null) {
            builder.field(Field.LAST_CHECKED.getPreferredName(), (ReadableInstant)this.lastChecked);
        }
        if (this.lastMetCondition != null) {
            builder.field(Field.LAST_MET_CONDITION.getPreferredName(), (ReadableInstant)this.lastMetCondition);
        }
        if (this.actions != null) {
            builder.startObject(Field.ACTIONS.getPreferredName());
            for (Map.Entry entry : this.actions.entrySet()) {
                builder.field((String)entry.getKey(), (ToXContent)entry.getValue(), params);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public static WatchStatus parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        State state = null;
        DateTime lastChecked = null;
        DateTime lastMetCondition = null;
        ImmutableMap.Builder actions = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.STATE)) {
                try {
                    state = State.parse(parser);
                    continue;
                }
                catch (ElasticsearchParseException e) {
                    throw new ElasticsearchParseException("could not parse watch status for [{}]. failed to parse field [{}]", (Throwable)e, new Object[]{watchId, currentFieldName});
                }
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.LAST_CHECKED)) {
                if (token.isValue()) {
                    lastChecked = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.LAST_MET_CONDITION)) {
                if (token.isValue()) {
                    lastMetCondition = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
                    continue;
                }
                throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to hold a date value, found [{}] instead", new Object[]{watchId, currentFieldName, token});
            }
            if (!ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACTIONS)) continue;
            actions = ImmutableMap.builder();
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    ActionStatus actionStatus = ActionStatus.parse(watchId, currentFieldName, parser);
                    actions.put((Object)currentFieldName, (Object)actionStatus);
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse watch status for [{}]. expecting field [{}] to be an object, found [{}] instead", new Object[]{watchId, currentFieldName, token});
        }
        if (state == null) {
            state = new State(true, WatcherXContentParser.clock(parser).nowUTC());
        }
        return new WatchStatus(-1L, state, lastChecked, lastMetCondition, (ImmutableMap<String, ActionStatus>)actions.build());
    }

    static interface Field {
        public static final ParseField VERSION = new ParseField("version", new String[0]);
        public static final ParseField STATE = new ParseField("state", new String[0]);
        public static final ParseField ACTIVE = new ParseField("active", new String[0]);
        public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
        public static final ParseField LAST_CHECKED = new ParseField("last_checked", new String[0]);
        public static final ParseField LAST_MET_CONDITION = new ParseField("last_met_condition", new String[0]);
        public static final ParseField ACTIONS = new ParseField("actions", new String[0]);
    }

    public static class State
    implements ToXContent {
        final boolean active;
        final DateTime timestamp;

        public State(boolean active, DateTime timestamp) {
            this.active = active;
            this.timestamp = timestamp;
        }

        public boolean isActive() {
            return this.active;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Field.ACTIVE.getPreferredName(), this.active);
            WatcherDateTimeUtils.writeDate(Field.TIMESTAMP.getPreferredName(), builder, this.timestamp);
            return builder.endObject();
        }

        public static State parse(XContentParser parser) throws IOException {
            XContentParser.Token token;
            if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("expected an object but found [{}] instead", new Object[]{parser.currentToken()});
            }
            boolean active = true;
            DateTime timestamp = SystemClock.INSTANCE.nowUTC();
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ACTIVE)) {
                    active = parser.booleanValue();
                    continue;
                }
                if (!ParseFieldMatcher.STRICT.match(currentFieldName, Field.TIMESTAMP)) continue;
                timestamp = WatcherDateTimeUtils.parseDate(currentFieldName, parser, DateTimeZone.UTC);
            }
            return new State(active, timestamp);
        }
    }
}

