/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.WatcherDateTimeUtils;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.trigger.AbstractTriggerEngine;
import org.elasticsearch.watcher.trigger.TriggerService;
import org.elasticsearch.watcher.trigger.schedule.Schedule;
import org.elasticsearch.watcher.trigger.schedule.ScheduleRegistry;
import org.elasticsearch.watcher.trigger.schedule.ScheduleTrigger;
import org.elasticsearch.watcher.trigger.schedule.ScheduleTriggerEvent;
import org.joda.time.DateTime;

public abstract class ScheduleTriggerEngine
extends AbstractTriggerEngine<ScheduleTrigger, ScheduleTriggerEvent> {
    public static final String TYPE = "schedule";
    protected final ScheduleRegistry scheduleRegistry;
    protected final Clock clock;

    public ScheduleTriggerEngine(Settings settings, ScheduleRegistry scheduleRegistry, Clock clock) {
        super(settings);
        this.scheduleRegistry = scheduleRegistry;
        this.clock = clock;
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public ScheduleTriggerEvent simulateEvent(String jobId, @Nullable Map<String, Object> data, TriggerService service) {
        DateTime scheduledTime;
        DateTime triggeredTime;
        DateTime now = this.clock.nowUTC();
        if (data == null) {
            return new ScheduleTriggerEvent(jobId, now, now);
        }
        Object value = data.get(ScheduleTriggerEvent.Field.TRIGGERED_TIME.getPreferredName());
        DateTime dateTime = triggeredTime = value != null ? WatcherDateTimeUtils.convertToDate(value, this.clock) : now;
        if (triggeredTime == null) {
            throw Exceptions.illegalArgument("could not simulate schedule event. could not convert provided triggered time [{}] to date/time", value);
        }
        value = data.get(ScheduleTriggerEvent.Field.SCHEDULED_TIME.getPreferredName());
        DateTime dateTime2 = scheduledTime = value != null ? WatcherDateTimeUtils.convertToDate(value, this.clock) : triggeredTime;
        if (scheduledTime == null) {
            throw Exceptions.illegalArgument("could not simulate schedule event. could not convert provided scheduled time [{}] to date/time", value);
        }
        return new ScheduleTriggerEvent(jobId, triggeredTime, scheduledTime);
    }

    @Override
    public ScheduleTrigger parseTrigger(String context, XContentParser parser) throws IOException {
        Schedule schedule = this.scheduleRegistry.parse(context, parser);
        return new ScheduleTrigger(schedule);
    }

    @Override
    public ScheduleTriggerEvent parseTriggerEvent(TriggerService service, String watchId, String context, XContentParser parser) throws IOException {
        return ScheduleTriggerEvent.parse(parser, watchId, context, this.clock);
    }
}

