/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.schedule;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.trigger.Trigger;
import org.elasticsearch.watcher.trigger.schedule.Schedule;

public class ScheduleTrigger
implements Trigger {
    public static final String TYPE = "schedule";
    private final Schedule schedule;

    public ScheduleTrigger(Schedule schedule) {
        this.schedule = schedule;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleTrigger trigger = (ScheduleTrigger)o;
        return this.schedule.equals(trigger.schedule);
    }

    public int hashCode() {
        return this.schedule.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(this.schedule.type(), (ToXContent)this.schedule, params).endObject();
    }

    public static Builder builder(Schedule schedule) {
        return new Builder(schedule);
    }

    public static class Builder
    implements Trigger.Builder<ScheduleTrigger> {
        private final Schedule schedule;

        private Builder(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public ScheduleTrigger build() {
            return new ScheduleTrigger(this.schedule);
        }
    }
}

