/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.trigger.manual;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.trigger.TriggerEngine;
import org.elasticsearch.watcher.trigger.TriggerService;
import org.elasticsearch.watcher.trigger.manual.ManualTrigger;
import org.elasticsearch.watcher.trigger.manual.ManualTriggerEvent;

public class ManualTriggerEngine
implements TriggerEngine<ManualTrigger, ManualTriggerEvent> {
    static final String TYPE = "manual";

    @Inject
    public ManualTriggerEngine() {
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void start(Collection<TriggerEngine.Job> jobs) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void register(TriggerEngine.Listener listener) {
    }

    @Override
    public void add(TriggerEngine.Job job) {
    }

    @Override
    public boolean remove(String jobId) {
        return false;
    }

    @Override
    public ManualTriggerEvent simulateEvent(String jobId, @Nullable Map<String, Object> data, TriggerService service) {
        if (data == null) {
            throw Exceptions.illegalArgument("could not simulate manual trigger event. missing required simulated trigger type", new Object[0]);
        }
        if (data.size() == 1) {
            String type = data.keySet().iterator().next();
            return new ManualTriggerEvent(jobId, service.simulateEvent(type, jobId, data));
        }
        Object type = data.get("type");
        if (type instanceof String) {
            return new ManualTriggerEvent(jobId, service.simulateEvent((String)type, jobId, data));
        }
        throw Exceptions.illegalArgument("could not simulate manual trigger event. could not resolve simulated trigger type", new Object[0]);
    }

    @Override
    public ManualTrigger parseTrigger(String context, XContentParser parser) throws IOException {
        return ManualTrigger.parse(parser);
    }

    @Override
    public ManualTriggerEvent parseTriggerEvent(TriggerService service, String watchId, String context, XContentParser parser) throws IOException {
        return ManualTriggerEvent.parse(service, watchId, context, parser);
    }
}

