/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.put;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.client.WatchSourceBuilder;
import org.elasticsearch.watcher.support.validation.Validation;

public class PutWatchRequest
extends MasterNodeRequest<PutWatchRequest> {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
    private String id;
    private BytesReference source;
    private boolean active = true;

    public PutWatchRequest() {
    }

    public PutWatchRequest(String id, WatchSourceBuilder source) {
        this(id, source.buildAsBytes(XContentType.JSON));
    }

    public PutWatchRequest(String id, BytesReference source) {
        this.id = id;
        this.source = source;
        this.masterNodeTimeout(DEFAULT_TIMEOUT);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(WatchSourceBuilder source) {
        this.setSource(source.buildAsBytes(XContentType.JSON));
    }

    public void setSource(BytesReference source) {
        this.source = source;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public ActionRequestValidationException validate() {
        Validation.Error error;
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError((String)"watch name is missing", validationException);
        }
        if ((error = Validation.watchId(this.id)) != null) {
            validationException = ValidateActions.addValidationError((String)error.message(), (ActionRequestValidationException)validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"watch source is missing", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.active = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeBoolean(this.active);
    }
}

