/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transport.actions.delete;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.WatcherService;
import org.elasticsearch.watcher.license.WatcherLicensee;
import org.elasticsearch.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchRequest;
import org.elasticsearch.watcher.transport.actions.delete.DeleteWatchResponse;

public class TransportDeleteWatchAction
extends WatcherTransportAction<DeleteWatchRequest, DeleteWatchResponse> {
    private final WatcherService watcherService;

    @Inject
    public TransportDeleteWatchAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, WatcherService watcherService, WatcherLicensee watcherLicensee) {
        super(settings, "cluster:admin/watcher/watch/delete", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, watcherLicensee, DeleteWatchRequest.class);
        this.watcherService = watcherService;
    }

    protected String executor() {
        return "management";
    }

    protected DeleteWatchResponse newResponse() {
        return new DeleteWatchResponse();
    }

    protected void masterOperation(DeleteWatchRequest request, ClusterState state, ActionListener<DeleteWatchResponse> listener) throws ElasticsearchException {
        try {
            DeleteResponse deleteResponse = this.watcherService.deleteWatch(request.getId(), request.masterNodeTimeout(), request.isForce()).deleteResponse();
            DeleteWatchResponse response = new DeleteWatchResponse(deleteResponse.getId(), deleteResponse.getVersion(), deleteResponse.isFound());
            listener.onResponse((Object)response);
        }
        catch (Exception e) {
            listener.onFailure((Throwable)e);
        }
    }

    protected ClusterBlockException checkBlock(DeleteWatchRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, ".watches");
    }
}

