/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.search;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;
import org.elasticsearch.watcher.transform.TransformFactory;
import org.elasticsearch.watcher.transform.search.ExecutableSearchTransform;
import org.elasticsearch.watcher.transform.search.SearchTransform;

public class SearchTransformFactory
extends TransformFactory<SearchTransform, SearchTransform.Result, ExecutableSearchTransform> {
    protected final ClientProxy client;
    private final TimeValue defaultTimeout;

    @Inject
    public SearchTransformFactory(Settings settings, ClientProxy client) {
        super(Loggers.getLogger(ExecutableSearchTransform.class, (Settings)settings, (String[])new String[0]));
        this.client = client;
        this.defaultTimeout = settings.getAsTime("watcher.transform.search.default_timeout", null);
    }

    @Override
    public String type() {
        return "search";
    }

    @Override
    public SearchTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return SearchTransform.parse(watchId, parser);
    }

    @Override
    public ExecutableSearchTransform createExecutable(SearchTransform transform) {
        return new ExecutableSearchTransform(transform, this.transformLogger, this.client, this.defaultTimeout);
    }
}

