/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.Script;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;
import org.elasticsearch.watcher.transform.ExecutableTransform;
import org.elasticsearch.watcher.transform.script.ScriptTransform;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableScriptTransform
extends ExecutableTransform<ScriptTransform, ScriptTransform.Result> {
    private final ScriptServiceProxy scriptService;
    private final CompiledScript compiledScript;

    public ExecutableScriptTransform(ScriptTransform transform, ESLogger logger, ScriptServiceProxy scriptService) {
        super(transform, logger);
        this.scriptService = scriptService;
        Script script = transform.getScript();
        try {
            this.compiledScript = scriptService.compile(script);
        }
        catch (Exception e) {
            throw Exceptions.invalidScript("failed to compile script [{}] with lang [{}] of type [{}]", e, script.script(), script.lang(), script.type(), e);
        }
    }

    @Override
    public ScriptTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        try {
            return this.doExecute(ctx, payload);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] transform for [{}]", (Throwable)e, new Object[]{"script", ctx.id()});
            return new ScriptTransform.Result(e);
        }
    }

    ScriptTransform.Result doExecute(WatchExecutionContext ctx, Payload payload) throws IOException {
        Script script = ((ScriptTransform)this.transform).getScript();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(script.params());
        model.putAll(Variables.createCtxModel(ctx, payload));
        ExecutableScript executable = this.scriptService.executable(this.compiledScript, model);
        Object value = executable.run();
        if (value instanceof Map) {
            return new ScriptTransform.Result(new Payload.Simple((Map)value));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("_value", value);
        return new ScriptTransform.Result(new Payload.Simple(data));
    }
}

