/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform.chain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.transform.TransformRegistry;
import org.elasticsearch.watcher.watch.Payload;

public class ChainTransform
implements Transform {
    public static final String TYPE = "chain";
    private final List<Transform> transforms;

    public ChainTransform(Transform ... transforms) {
        this(Arrays.asList(transforms));
    }

    public ChainTransform(List<Transform> transforms) {
        this.transforms = Collections.unmodifiableList(transforms);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public List<Transform> getTransforms() {
        return this.transforms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainTransform that = (ChainTransform)o;
        return this.transforms.equals(that.transforms);
    }

    public int hashCode() {
        return this.transforms.hashCode();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray();
        for (Transform transform : this.transforms) {
            builder.startObject().field(transform.type(), (ToXContent)transform, params).endObject();
        }
        return builder.endArray();
    }

    public static ChainTransform parse(String watchId, XContentParser parser, TransformRegistry transformRegistry) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. expected an array of transform objects, but found [{}] instead", new Object[]{TYPE, watchId, token});
        }
        ArrayList<Transform> transforms = new ArrayList<Transform>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("could not parse [{}] transform for watch [{}]. expected a transform object, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                transforms.add(transformRegistry.parseTransform(watchId, currentFieldName, parser));
            }
        }
        return new ChainTransform(transforms);
    }

    public static Builder builder(Transform ... transforms) {
        return new Builder(transforms);
    }

    static interface Field
    extends Transform.Field {
        public static final ParseField RESULTS = new ParseField("results", new String[0]);
    }

    public static class Builder
    implements Transform.Builder<ChainTransform> {
        private final List<Transform> transforms = new ArrayList<Transform>();

        public Builder(Transform ... transforms) {
            this.add(transforms);
        }

        public Builder add(Transform ... transforms) {
            Collections.addAll(this.transforms, transforms);
            return this;
        }

        public Builder add(Transform.Builder ... transforms) {
            for (Transform.Builder transform : transforms) {
                this.transforms.add((Transform)transform.build());
            }
            return this;
        }

        @Override
        public ChainTransform build() {
            return new ChainTransform(this.transforms);
        }
    }

    public static class Result
    extends Transform.Result {
        private final List<Transform.Result> results;

        public Result(Payload payload, List<Transform.Result> results) {
            super(ChainTransform.TYPE, payload);
            this.results = Collections.unmodifiableList(results);
        }

        public Result(Exception e, List<Transform.Result> results) {
            super(ChainTransform.TYPE, e);
            this.results = Collections.unmodifiableList(results);
        }

        public Result(String errorMessage, List<Transform.Result> results) {
            super(ChainTransform.TYPE, errorMessage);
            this.results = Collections.unmodifiableList(results);
        }

        public List<Transform.Result> results() {
            return this.results;
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.results.isEmpty()) {
                builder.startObject(this.type);
                builder.startArray(Field.RESULTS.getPreferredName());
                for (Transform.Result result : this.results) {
                    result.toXContent(builder, params);
                }
                builder.endArray();
                builder.endObject();
            }
            return builder;
        }
    }
}

