/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.transform;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.transform.ExecutableTransform;
import org.elasticsearch.watcher.transform.Transform;
import org.elasticsearch.watcher.transform.TransformFactory;

public class TransformRegistry {
    private final Map<String, TransformFactory> factories;

    @Inject
    public TransformRegistry(Map<String, TransformFactory> factories) {
        this.factories = ImmutableMap.copyOf(factories);
    }

    public TransformFactory factory(String type) {
        return this.factories.get(type);
    }

    public ExecutableTransform parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        ExecutableTransform transform = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type == null) continue;
            transform = this.parse(watchId, type, parser);
        }
        return transform;
    }

    public ExecutableTransform parse(String watchId, String type, XContentParser parser) throws IOException {
        TransformFactory factory = this.factories.get(type);
        if (factory == null) {
            throw new ElasticsearchParseException("could not parse transform for watch [{}], unknown transform type [{}]", new Object[]{watchId, type});
        }
        return factory.parseExecutable(watchId, parser);
    }

    public Transform parseTransform(String watchId, String type, XContentParser parser) throws IOException {
        TransformFactory factory = this.factories.get(type);
        if (factory == null) {
            throw new ElasticsearchParseException("could not parse transform for watch [{}], unknown transform type [{}]", new Object[]{watchId, type});
        }
        return factory.parseTransform(watchId, parser);
    }
}

