/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class WatcherXContentUtils {
    private WatcherXContentUtils() {
    }

    public static Tuple<XContentType, Object> convertToObject(BytesReference bytes) throws ElasticsearchParseException {
        try {
            XContentParser parser = XContentHelper.createParser((BytesReference)bytes);
            return Tuple.tuple((Object)parser.contentType(), (Object)WatcherXContentUtils.readValue(parser, parser.nextToken()));
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("Failed to parse content to map", (Throwable)e, new Object[0]);
        }
    }

    public static String[] readStringArray(XContentParser parser, boolean allowNull) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            if (allowNull) {
                return null;
            }
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but found null value instead", new Object[]{parser.currentName()});
        }
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but found [{}] value instead", new Object[]{parser.currentName(), parser.currentToken()});
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token == XContentParser.Token.VALUE_STRING) {
                list.add(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("could not parse [{}] field. expected a string array but one of the value in the array is [{}]", new Object[]{parser.currentName(), token});
        }
        return list.toArray(new String[list.size()]);
    }

    public static List<Object> readList(XContentParser parser, XContentParser.Token token) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            list.add(WatcherXContentUtils.readValue(parser, token));
        }
        return list;
    }

    public static Object readValue(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = parser.numberType();
            if (numberType == XContentParser.NumberType.INT) {
                return parser.intValue();
            }
            if (numberType == XContentParser.NumberType.LONG) {
                return parser.longValue();
            }
            if (numberType == XContentParser.NumberType.FLOAT) {
                return Float.valueOf(parser.floatValue());
            }
            if (numberType == XContentParser.NumberType.DOUBLE) {
                return parser.doubleValue();
            }
        } else {
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                return parser.booleanValue();
            }
            if (token == XContentParser.Token.START_OBJECT) {
                return parser.map();
            }
            if (token == XContentParser.Token.START_ARRAY) {
                return WatcherXContentUtils.readList(parser, token);
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                return parser.binaryValue();
            }
        }
        return null;
    }
}

