/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.xcontent;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.support.clock.SystemClock;
import org.elasticsearch.watcher.support.secret.Secret;
import org.elasticsearch.watcher.support.secret.SecretService;

public class WatcherXContentParser
implements XContentParser {
    private final Clock clock;
    private final XContentParser parser;
    @Nullable
    private final SecretService secretService;

    public static Secret secret(XContentParser parser) throws IOException {
        char[] chars = parser.text().toCharArray();
        if (parser instanceof WatcherXContentParser) {
            WatcherXContentParser watcherParser = (WatcherXContentParser)parser;
            if (watcherParser.secretService != null) {
                chars = watcherParser.secretService.encrypt(chars);
            }
        }
        return new Secret(chars);
    }

    public static Secret secretOrNull(XContentParser parser) throws IOException {
        String text = parser.textOrNull();
        if (text == null) {
            return null;
        }
        char[] chars = parser.text().toCharArray();
        if (parser instanceof WatcherXContentParser) {
            WatcherXContentParser watcherParser = (WatcherXContentParser)parser;
            if (watcherParser.secretService != null) {
                chars = watcherParser.secretService.encrypt(text.toCharArray());
            }
            return new Secret(chars);
        }
        return new Secret(chars);
    }

    public static Clock clock(XContentParser parser) {
        if (parser instanceof WatcherXContentParser) {
            return ((WatcherXContentParser)parser).clock;
        }
        return SystemClock.INSTANCE;
    }

    public WatcherXContentParser(XContentParser parser, Clock clock, @Nullable SecretService secretService) {
        this.clock = clock;
        this.parser = parser;
        this.secretService = secretService;
    }

    public XContentType contentType() {
        return this.parser.contentType();
    }

    public XContentParser.Token nextToken() throws IOException {
        return this.parser.nextToken();
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public XContentParser.Token currentToken() {
        return this.parser.currentToken();
    }

    public String currentName() throws IOException {
        return this.parser.currentName();
    }

    public Map<String, Object> map() throws IOException {
        return this.parser.map();
    }

    public Map<String, Object> mapOrdered() throws IOException {
        return this.parser.mapOrdered();
    }

    public List<Object> list() throws IOException {
        return this.parser.list();
    }

    public List<Object> listOrderedMap() throws IOException {
        return this.parser.listOrderedMap();
    }

    public String text() throws IOException {
        return this.parser.text();
    }

    public String textOrNull() throws IOException {
        return this.parser.textOrNull();
    }

    public BytesRef utf8BytesOrNull() throws IOException {
        return this.parser.utf8BytesOrNull();
    }

    public BytesRef utf8Bytes() throws IOException {
        return this.parser.utf8Bytes();
    }

    public Object objectText() throws IOException {
        return this.parser.objectText();
    }

    public Object objectBytes() throws IOException {
        return this.parser.objectBytes();
    }

    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    public char[] textCharacters() throws IOException {
        return this.parser.textCharacters();
    }

    public int textLength() throws IOException {
        return this.parser.textLength();
    }

    public int textOffset() throws IOException {
        return this.parser.textOffset();
    }

    public Number numberValue() throws IOException {
        return this.parser.numberValue();
    }

    public XContentParser.NumberType numberType() throws IOException {
        return this.parser.numberType();
    }

    public short shortValue(boolean coerce) throws IOException {
        return this.parser.shortValue(coerce);
    }

    public int intValue(boolean coerce) throws IOException {
        return this.parser.intValue(coerce);
    }

    public long longValue(boolean coerce) throws IOException {
        return this.parser.longValue(coerce);
    }

    public float floatValue(boolean coerce) throws IOException {
        return this.parser.floatValue(coerce);
    }

    public double doubleValue(boolean coerce) throws IOException {
        return this.parser.doubleValue(coerce);
    }

    public short shortValue() throws IOException {
        return this.parser.shortValue();
    }

    public int intValue() throws IOException {
        return this.parser.intValue();
    }

    public long longValue() throws IOException {
        return this.parser.longValue();
    }

    public float floatValue() throws IOException {
        return this.parser.floatValue();
    }

    public double doubleValue() throws IOException {
        return this.parser.doubleValue();
    }

    public boolean isBooleanValue() throws IOException {
        return this.parser.isBooleanValue();
    }

    public boolean booleanValue() throws IOException {
        return this.parser.booleanValue();
    }

    public byte[] binaryValue() throws IOException {
        return this.parser.binaryValue();
    }

    public XContentLocation getTokenLocation() {
        return this.parser.getTokenLocation();
    }

    public boolean isClosed() {
        return this.parser.isClosed();
    }

    public void close() throws ElasticsearchException {
        this.parser.close();
    }
}

