/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.xcontent;

import com.google.common.collect.ImmutableMap;
import org.elasticsearch.common.xcontent.ToXContent;

public class WatcherParams
extends ToXContent.DelegatingMapParams {
    public static final WatcherParams HIDE_SECRETS = WatcherParams.builder().hideSecrets(true).build();
    static final String HIDE_SECRETS_KEY = "hide_secrets";
    static final String COLLAPSE_ARRAYS_KEY = "collapse_arrays";
    static final String DEBUG_KEY = "debug";

    public static boolean hideSecrets(ToXContent.Params params) {
        return WatcherParams.wrap(params).hideSecrets();
    }

    public static boolean collapseArrays(ToXContent.Params params) {
        return WatcherParams.wrap(params).collapseArrays();
    }

    public static boolean debug(ToXContent.Params params) {
        return WatcherParams.wrap(params).debug();
    }

    private WatcherParams(ImmutableMap<String, String> params, ToXContent.Params delegate) {
        super(params, delegate);
    }

    public boolean hideSecrets() {
        return this.paramAsBoolean(HIDE_SECRETS_KEY, false);
    }

    public boolean collapseArrays() {
        return this.paramAsBoolean(COLLAPSE_ARRAYS_KEY, false);
    }

    public boolean debug() {
        return this.paramAsBoolean(DEBUG_KEY, false);
    }

    public static WatcherParams wrap(ToXContent.Params params) {
        return params instanceof WatcherParams ? (WatcherParams)params : new WatcherParams((ImmutableMap<String, String>)ImmutableMap.of(), params);
    }

    public static Builder builder() {
        return WatcherParams.builder(ToXContent.EMPTY_PARAMS);
    }

    public static Builder builder(ToXContent.Params delegate) {
        return new Builder(delegate);
    }

    public static class Builder {
        private final ToXContent.Params delegate;
        private final ImmutableMap.Builder<String, String> params = ImmutableMap.builder();

        private Builder(ToXContent.Params delegate) {
            this.delegate = delegate;
        }

        public Builder hideSecrets(boolean hideSecrets) {
            this.params.put((Object)WatcherParams.HIDE_SECRETS_KEY, (Object)String.valueOf(hideSecrets));
            return this;
        }

        public Builder collapseArrays(boolean collapseArrays) {
            this.params.put((Object)WatcherParams.COLLAPSE_ARRAYS_KEY, (Object)String.valueOf(collapseArrays));
            return this;
        }

        public Builder debug(boolean debug) {
            this.params.put((Object)WatcherParams.DEBUG_KEY, (Object)String.valueOf(debug));
            return this;
        }

        public Builder put(String key, Object value) {
            this.params.put((Object)key, (Object)String.valueOf(value));
            return this;
        }

        public WatcherParams build() {
            return new WatcherParams(this.params.build(), this.delegate);
        }
    }
}

