/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.text;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.ScriptService;

public class TextTemplate
implements ToXContent {
    private final String template;
    @Nullable
    private final XContentType contentType;
    @Nullable
    private final ScriptService.ScriptType type;
    @Nullable
    private final Map<String, Object> params;

    public TextTemplate(String template) {
        this(template, null, null, null);
    }

    public TextTemplate(String template, @Nullable XContentType contentType, @Nullable ScriptService.ScriptType type, @Nullable Map<String, Object> params) {
        this.template = template;
        this.contentType = contentType;
        this.type = type;
        this.params = params;
    }

    public String getTemplate() {
        return this.template;
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    public ScriptService.ScriptType getType() {
        return this.type != null ? this.type : ScriptService.ScriptType.INLINE;
    }

    public Map<String, Object> getParams() {
        return this.params != null ? this.params : Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextTemplate template1 = (TextTemplate)o;
        if (!this.template.equals(template1.template)) {
            return false;
        }
        if (this.contentType != template1.contentType) {
            return false;
        }
        if (this.type != template1.type) {
            return false;
        }
        return !(this.params == null ? template1.params != null : !this.params.equals(template1.params));
    }

    public int hashCode() {
        int result = this.template.hashCode();
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.type == null) {
            return builder.value(this.template);
        }
        builder.startObject();
        switch (this.type) {
            case INLINE: {
                if (this.contentType != null && builder.contentType() == this.contentType) {
                    builder.rawField(Field.INLINE.getPreferredName(), (BytesReference)new BytesArray(this.template));
                    break;
                }
                builder.field(Field.INLINE.getPreferredName(), this.template);
                break;
            }
            case FILE: {
                builder.field(Field.FILE.getPreferredName(), this.template);
                break;
            }
            default: {
                assert (this.type == ScriptService.ScriptType.INDEXED) : "template type [" + this.type + "] is not supported";
                builder.field(Field.ID.getPreferredName(), this.template);
            }
        }
        if (this.params != null) {
            builder.field(Field.PARAMS.getPreferredName(), this.params);
        }
        return builder.endObject();
    }

    public static TextTemplate parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token.isValue()) {
            return new TextTemplate(String.valueOf(parser.objectText()));
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("expected a string value or an object, but found [{}] instead", new Object[]{token});
        }
        String template = null;
        XContentType contentType = null;
        ScriptService.ScriptType type = null;
        Map params = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.INLINE)) {
                type = ScriptService.ScriptType.INLINE;
                if (token.isValue()) {
                    template = String.valueOf(parser.objectText());
                    continue;
                }
                contentType = parser.contentType();
                XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
                template = builder.copyCurrentStructure(parser).bytes().toUtf8();
                continue;
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.FILE)) {
                type = ScriptService.ScriptType.FILE;
                if (token == XContentParser.Token.VALUE_STRING) {
                    template = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.ID)) {
                type = ScriptService.ScriptType.INDEXED;
                if (token == XContentParser.Token.VALUE_STRING) {
                    template = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("expected a string value for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            if (ParseFieldMatcher.STRICT.match(currentFieldName, Field.PARAMS)) {
                if (token == XContentParser.Token.START_OBJECT) {
                    params = parser.map();
                    continue;
                }
                throw new ElasticsearchParseException("expected an object for field [{}], but found [{}]", new Object[]{currentFieldName, token});
            }
            throw new ElasticsearchParseException("unexpected field [{}]", new Object[]{currentFieldName});
        }
        if (template == null) {
            throw new ElasticsearchParseException("expected one of [{}], [{}] or [{}] fields, but found none", new Object[]{Field.INLINE.getPreferredName(), Field.FILE.getPreferredName(), Field.ID.getPreferredName()});
        }
        assert (type != null) : "if template is not null, type should definitely not be null";
        return new TextTemplate(template, contentType, type, params);
    }

    public static Builder inline(XContentBuilder template) {
        return new Builder.Inline(template.bytes().toUtf8()).contentType(template.contentType());
    }

    public static Builder inline(String text) {
        return new Builder.Inline(text);
    }

    public static Builder file(String file) {
        return new Builder.File(file);
    }

    public static Builder indexed(String id) {
        return new Builder.Indexed(id);
    }

    public static Builder.DefaultType defaultType(String text) {
        return new Builder.DefaultType(text);
    }

    public static interface Field {
        public static final ParseField INLINE = new ParseField("inline", new String[0]);
        public static final ParseField FILE = new ParseField("file", new String[0]);
        public static final ParseField ID = new ParseField("id", new String[0]);
        public static final ParseField PARAMS = new ParseField("params", new String[0]);
    }

    public static abstract class Builder<B extends Builder> {
        protected final ScriptService.ScriptType type;
        protected final String template;
        protected Map<String, Object> params;

        protected Builder(String template, ScriptService.ScriptType type) {
            this.template = template;
            this.type = type;
        }

        public B params(Map<String, Object> params) {
            this.params = params;
            return (B)this;
        }

        public abstract TextTemplate build();

        public static class DefaultType
        extends Builder<DefaultType> {
            public DefaultType(String text) {
                super(text, null);
            }

            @Override
            public TextTemplate build() {
                return new TextTemplate(this.template, null, this.type, this.params);
            }
        }

        public static class Indexed
        extends Builder<Indexed> {
            public Indexed(String id) {
                super(id, ScriptService.ScriptType.INDEXED);
            }

            @Override
            public TextTemplate build() {
                return new TextTemplate(this.template, null, this.type, this.params);
            }
        }

        public static class File
        extends Builder<File> {
            public File(String file) {
                super(file, ScriptService.ScriptType.FILE);
            }

            @Override
            public TextTemplate build() {
                return new TextTemplate(this.template, null, this.type, this.params);
            }
        }

        public static class Inline
        extends Builder<Inline> {
            private XContentType contentType;

            public Inline(String script) {
                super(script, ScriptService.ScriptType.INLINE);
            }

            public Inline contentType(XContentType contentType) {
                this.contentType = contentType;
                return this;
            }

            @Override
            public TextTemplate build() {
                return new TextTemplate(this.template, this.contentType, this.type, this.params);
            }
        }
    }
}

