/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.Template;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;
import org.elasticsearch.watcher.support.text.TextTemplate;
import org.elasticsearch.watcher.support.text.TextTemplateEngine;

public class DefaultTextTemplateEngine
extends AbstractComponent
implements TextTemplateEngine {
    private final ScriptServiceProxy service;

    @Inject
    public DefaultTextTemplateEngine(Settings settings, ScriptServiceProxy service) {
        super(settings);
        this.service = service;
    }

    @Override
    public String render(TextTemplate textTemplate, Map<String, Object> model) {
        if (textTemplate == null) {
            return null;
        }
        XContentType contentType = this.detectContentType(textTemplate);
        Map<String, String> compileParams = this.compileParams(contentType);
        textTemplate = this.trimContentType(textTemplate);
        HashMap<String, Object> mergedModel = new HashMap<String, Object>();
        mergedModel.putAll(textTemplate.getParams());
        mergedModel.putAll(model);
        Template template = new Template(textTemplate.getTemplate(), textTemplate.getType(), "mustache", textTemplate.getContentType(), mergedModel);
        CompiledScript compiledScript = this.service.compile((Script)template, compileParams);
        ExecutableScript executable = this.service.executable(compiledScript, mergedModel);
        Object result = executable.run();
        if (result instanceof BytesReference) {
            return ((BytesReference)result).toUtf8();
        }
        return result.toString();
    }

    private TextTemplate trimContentType(TextTemplate textTemplate) {
        String template = textTemplate.getTemplate();
        if (!template.startsWith("__")) {
            return textTemplate;
        }
        int index = template.indexOf("__::", 3);
        if (index >= 0 && index < 12) {
            template = template.length() == 6 ? "" : template.substring(index + 4);
        }
        return new TextTemplate(template, textTemplate.getContentType(), textTemplate.getType(), textTemplate.getParams());
    }

    private XContentType detectContentType(TextTemplate textTemplate) {
        int endOfContentName;
        String template = textTemplate.getTemplate();
        if (template.startsWith("__") && (endOfContentName = template.indexOf("__::", 3)) != -1) {
            return XContentType.fromRestContentType((String)template.substring(2, endOfContentName));
        }
        return null;
    }

    private Map<String, String> compileParams(XContentType contentType) {
        if (contentType == XContentType.JSON) {
            return Collections.singletonMap("content_type", "application/json");
        }
        return Collections.singletonMap("content_type", "text/plain");
    }
}

