/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.init.proxy;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.watcher.shield.ShieldIntegration;
import org.elasticsearch.watcher.support.Script;
import org.elasticsearch.watcher.support.init.InitializingService;

public class ScriptServiceProxy
implements InitializingService.Initializable {
    private ScriptService service;
    private ContextAndHeaderHolder contextAndHeaderHolder = new ContextAndHeaderHolder();
    public static final ScriptContext.Plugin INSTANCE = new ScriptContext.Plugin("elasticsearch-watcher", "watch");

    public static ScriptServiceProxy of(ScriptService service) {
        ScriptServiceProxy proxy = new ScriptServiceProxy();
        proxy.service = service;
        return proxy;
    }

    @Override
    public void init(Injector injector) {
        this.service = (ScriptService)injector.getInstance(ScriptService.class);
        ShieldIntegration shieldIntegration = (ShieldIntegration)injector.getInstance(ShieldIntegration.class);
        if (shieldIntegration != null) {
            shieldIntegration.putUserInContext((HasContext)this.contextAndHeaderHolder);
        }
    }

    public CompiledScript compile(Script script) {
        return this.compile(new org.elasticsearch.script.Script(script.script(), script.type(), script.lang(), script.params()), Collections.emptyMap());
    }

    public CompiledScript compile(org.elasticsearch.script.Script script, Map<String, String> compileParams) {
        return this.service.compile(script, WatcherScriptContext.CTX, (HasContextAndHeaders)this.contextAndHeaderHolder, compileParams);
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        return this.service.executable(compiledScript, vars);
    }

    public ExecutableScript executable(org.elasticsearch.script.Script script) {
        return this.service.executable(script, WatcherScriptContext.CTX, (HasContextAndHeaders)this.contextAndHeaderHolder, Collections.emptyMap());
    }

    private static class WatcherScriptContext
    implements ScriptContext {
        public static final ScriptContext CTX = new WatcherScriptContext();

        private WatcherScriptContext() {
        }

        public String getKey() {
            return INSTANCE.getKey();
        }
    }
}

