/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http.auth.basic;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.support.http.auth.HttpAuthFactory;
import org.elasticsearch.watcher.support.http.auth.basic.ApplicableBasicAuth;
import org.elasticsearch.watcher.support.http.auth.basic.BasicAuth;
import org.elasticsearch.watcher.support.secret.SecretService;

public class BasicAuthFactory
extends HttpAuthFactory<BasicAuth, ApplicableBasicAuth> {
    private final SecretService secretService;

    @Inject
    public BasicAuthFactory(SecretService secretService) {
        this.secretService = secretService;
    }

    @Override
    public String type() {
        return "basic";
    }

    @Override
    public BasicAuth parse(XContentParser parser) throws IOException {
        return BasicAuth.parse(parser);
    }

    @Override
    public ApplicableBasicAuth createApplicable(BasicAuth auth) {
        return new ApplicableBasicAuth(auth, this.secretService);
    }
}

