/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public enum HttpMethod implements ToXContent
{
    HEAD("HEAD"),
    GET("GET"),
    POST("POST"),
    PUT("PUT"),
    DELETE("DELETE");

    private final String method;

    private HttpMethod(String method) {
        this.method = method;
    }

    public String method() {
        return this.method;
    }

    public static HttpMethod parse(String value) {
        switch (value = value.toUpperCase(Locale.ROOT)) {
            case "HEAD": {
                return HEAD;
            }
            case "GET": {
                return GET;
            }
            case "POST": {
                return POST;
            }
            case "PUT": {
                return PUT;
            }
            case "DELETE": {
                return DELETE;
            }
        }
        throw new IllegalArgumentException("unsupported http method [" + value + "]");
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.value(this.name().toLowerCase(Locale.ROOT));
    }
}

