/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support.http;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.support.http.HttpProxy;
import org.elasticsearch.watcher.support.http.HttpRequest;
import org.elasticsearch.watcher.support.http.HttpResponse;
import org.elasticsearch.watcher.support.http.auth.ApplicableHttpAuth;
import org.elasticsearch.watcher.support.http.auth.HttpAuthRegistry;

public class HttpClient
extends AbstractLifecycleComponent<HttpClient> {
    static final String SETTINGS_SSL_PREFIX = "watcher.http.ssl.";
    static final String SETTINGS_PROXY_PREFIX = "watcher.http.proxy.";
    static final String SETTINGS_SSL_SHIELD_PREFIX = "shield.ssl.";
    public static final String SETTINGS_SSL_PROTOCOL = "watcher.http.ssl.protocol";
    static final String SETTINGS_SSL_SHIELD_PROTOCOL = "shield.ssl.protocol";
    public static final String SETTINGS_SSL_KEYSTORE = "watcher.http.ssl.keystore.path";
    static final String SETTINGS_SSL_SHIELD_KEYSTORE = "shield.ssl.keystore.path";
    public static final String SETTINGS_SSL_KEYSTORE_PASSWORD = "watcher.http.ssl.keystore.password";
    static final String SETTINGS_SSL_SHIELD_KEYSTORE_PASSWORD = "shield.ssl.keystore.password";
    public static final String SETTINGS_SSL_KEYSTORE_KEY_PASSWORD = "watcher.http.ssl.keystore.key_password";
    static final String SETTINGS_SSL_SHIELD_KEYSTORE_KEY_PASSWORD = "shield.ssl.keystore.key_password";
    public static final String SETTINGS_SSL_KEYSTORE_ALGORITHM = "watcher.http.ssl.keystore.algorithm";
    static final String SETTINGS_SSL_SHIELD_KEYSTORE_ALGORITHM = "shield.ssl.keystore.algorithm";
    public static final String SETTINGS_SSL_TRUSTSTORE = "watcher.http.ssl.truststore.path";
    static final String SETTINGS_SSL_SHIELD_TRUSTSTORE = "shield.ssl.truststore.path";
    public static final String SETTINGS_SSL_TRUSTSTORE_PASSWORD = "watcher.http.ssl.truststore.password";
    static final String SETTINGS_SSL_SHIELD_TRUSTSTORE_PASSWORD = "shield.ssl.truststore.password";
    public static final String SETTINGS_SSL_TRUSTSTORE_ALGORITHM = "watcher.http.ssl.truststore.algorithm";
    static final String SETTINGS_SSL_SHIELD_TRUSTSTORE_ALGORITHM = "shield.ssl.truststore.algorithm";
    public static final String SETTINGS_PROXY_HOST = "watcher.http.proxy.host";
    public static final String SETTINGS_PROXY_PORT = "watcher.http.proxy.port";
    private final HttpAuthRegistry httpAuthRegistry;
    private final Environment env;
    private final TimeValue defaultConnectionTimeout;
    private final TimeValue defaultReadTimeout;
    private SSLSocketFactory sslSocketFactory;
    private HttpProxy proxy = HttpProxy.NO_PROXY;

    @Inject
    public HttpClient(Settings settings, HttpAuthRegistry httpAuthRegistry, Environment env) {
        super(settings);
        this.httpAuthRegistry = httpAuthRegistry;
        this.env = env;
        this.defaultConnectionTimeout = settings.getAsTime("watcher.http.default_connection_timeout", TimeValue.timeValueSeconds((long)10L));
        this.defaultReadTimeout = settings.getAsTime("watcher.http.default_read_timeout", TimeValue.timeValueSeconds((long)10L));
    }

    protected void doStart() throws ElasticsearchException {
        Integer proxyPort = this.settings.getAsInt(SETTINGS_PROXY_PORT, null);
        String proxyHost = this.settings.get(SETTINGS_PROXY_HOST, null);
        if (proxyPort != null && Strings.hasText((String)proxyHost)) {
            this.proxy = new HttpProxy(proxyHost, proxyPort);
            this.logger.info("Using default proxy for http input and slack/hipchat/pagerduty/webhook actions [{}:{}]", new Object[]{proxyHost, proxyPort});
        } else if (proxyPort == null && Strings.hasText((String)proxyHost) || proxyPort != null && !Strings.hasText((String)proxyHost)) {
            this.logger.error("disabling proxy. Watcher HTTP HttpProxy requires both settings: [{}] and [{}]", new Object[]{SETTINGS_PROXY_HOST, SETTINGS_PROXY_PORT});
        }
        if (!this.settings.getByPrefix(SETTINGS_SSL_PREFIX).getAsMap().isEmpty() || !this.settings.getByPrefix(SETTINGS_SSL_SHIELD_PREFIX).getAsMap().isEmpty()) {
            this.sslSocketFactory = this.createSSLSocketFactory(this.settings);
        } else {
            this.logger.trace("no ssl context configured", new Object[0]);
            this.sslSocketFactory = null;
        }
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
    }

    public HttpResponse execute(HttpRequest request) throws IOException {
        try {
            return this.doExecute(request);
        }
        catch (SocketTimeoutException ste) {
            throw new ElasticsearchTimeoutException("failed to execute http request. timeout expired", (Throwable)ste, new Object[0]);
        }
    }

    public HttpResponse doExecute(HttpRequest request) throws IOException {
        byte[] body;
        String path;
        String queryString = null;
        if (request.params() != null && !request.params().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : request.params().entrySet()) {
                if (builder.length() != 0) {
                    builder.append('&');
                }
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            queryString = builder.toString();
        }
        String string = path = Strings.hasLength((String)request.path) ? request.path : "";
        if (Strings.hasLength(queryString)) {
            path = path + "?" + queryString;
        }
        URL url = new URL(request.scheme.scheme(), request.host, request.port, path);
        this.logger.debug("making [{}] request to [{}]", new Object[]{request.method().method(), url});
        this.logger.trace("sending [{}] as body of request", new Object[]{request.body()});
        HttpProxy proxyToUse = request.proxy != null ? request.proxy : this.proxy;
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(proxyToUse.proxy());
        if (urlConnection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            final HttpsURLConnection httpsConn = (HttpsURLConnection)urlConnection;
            final SSLSocketFactory factory = this.sslSocketFactory;
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    httpsConn.setSSLSocketFactory(factory);
                    return null;
                }
            });
        }
        urlConnection.setRequestMethod(request.method().method());
        if (request.headers() != null) {
            for (Map.Entry<String, String> entry : request.headers().entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (request.auth() != null) {
            this.logger.trace("applying auth headers", new Object[0]);
            Object applicableAuth = this.httpAuthRegistry.createApplicable(request.auth);
            ((ApplicableHttpAuth)applicableAuth).apply(urlConnection);
        }
        urlConnection.setUseCaches(false);
        urlConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        if (request.body() != null) {
            urlConnection.setDoOutput(true);
            byte[] bytes = request.body().getBytes(StandardCharsets.UTF_8.name());
            urlConnection.setRequestProperty("Content-Length", String.valueOf(bytes.length));
            urlConnection.getOutputStream().write(bytes);
            urlConnection.getOutputStream().close();
        }
        TimeValue connectionTimeout = request.connectionTimeout != null ? request.connectionTimeout : this.defaultConnectionTimeout;
        urlConnection.setConnectTimeout((int)connectionTimeout.millis());
        TimeValue readTimeout = request.readTimeout != null ? request.readTimeout : this.defaultReadTimeout;
        urlConnection.setReadTimeout((int)readTimeout.millis());
        urlConnection.connect();
        int statusCode = urlConnection.getResponseCode();
        ImmutableMap.Builder responseHeaders = ImmutableMap.builder();
        for (Map.Entry<String, List<String>> header : urlConnection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            responseHeaders.put((Object)header.getKey(), (Object)header.getValue().toArray(new String[header.getValue().size()]));
        }
        this.logger.debug("http status code [{}]", new Object[]{statusCode});
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            block49: {
                try (InputStream is = urlConnection.getInputStream();){
                    Streams.copy((InputStream)is, (OutputStream)outputStream);
                }
                catch (Exception e) {
                    if (urlConnection.getErrorStream() == null) break block49;
                    try (InputStream is2 = urlConnection.getErrorStream();){
                        Streams.copy((InputStream)is2, (OutputStream)outputStream);
                    }
                }
            }
            body = outputStream.toByteArray();
        }
        return new HttpResponse(statusCode, body, (ImmutableMap<String, String[]>)responseHeaders.build());
    }

    private SSLSocketFactory createSSLSocketFactory(Settings settings) {
        try {
            String sslContextProtocol = settings.get(SETTINGS_SSL_PROTOCOL, settings.get(SETTINGS_SSL_SHIELD_PROTOCOL, "TLS"));
            String keyStore = settings.get(SETTINGS_SSL_KEYSTORE, settings.get(SETTINGS_SSL_SHIELD_KEYSTORE, System.getProperty("javax.net.ssl.keyStore")));
            String keyStorePassword = settings.get(SETTINGS_SSL_KEYSTORE_PASSWORD, settings.get(SETTINGS_SSL_SHIELD_KEYSTORE_PASSWORD, System.getProperty("javax.net.ssl.keyStorePassword")));
            String keyPassword = settings.get(SETTINGS_SSL_KEYSTORE_KEY_PASSWORD, settings.get(SETTINGS_SSL_SHIELD_KEYSTORE_KEY_PASSWORD, keyStorePassword));
            String keyStoreAlgorithm = settings.get(SETTINGS_SSL_KEYSTORE_ALGORITHM, settings.get(SETTINGS_SSL_SHIELD_KEYSTORE_ALGORITHM, System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm())));
            String trustStore = settings.get(SETTINGS_SSL_TRUSTSTORE, settings.get(SETTINGS_SSL_SHIELD_TRUSTSTORE, System.getProperty("javax.net.ssl.trustStore")));
            String trustStorePassword = settings.get(SETTINGS_SSL_TRUSTSTORE_PASSWORD, settings.get(SETTINGS_SSL_SHIELD_TRUSTSTORE_PASSWORD, System.getProperty("javax.net.ssl.trustStorePassword")));
            String trustStoreAlgorithm = settings.get(SETTINGS_SSL_TRUSTSTORE_ALGORITHM, settings.get(SETTINGS_SSL_SHIELD_TRUSTSTORE_ALGORITHM, System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm())));
            if (keyStore != null) {
                if (trustStore == null) {
                    this.logger.debug("keystore defined with no truststore defined, using keystore as truststore", new Object[0]);
                    trustStore = keyStore;
                    trustStorePassword = keyStorePassword;
                    trustStoreAlgorithm = keyStoreAlgorithm;
                }
            } else if (trustStore == null) {
                this.logger.debug("no truststore defined, using system default", new Object[0]);
            }
            if (trustStoreAlgorithm == null) {
                trustStoreAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            }
            this.logger.debug("using protocol [{}], keyStore [{}], keyStoreAlgorithm [{}], trustStore [{}] and trustAlgorithm [{}]", new Object[]{sslContextProtocol, keyStore, keyStoreAlgorithm, trustStore, trustStoreAlgorithm});
            SSLContext sslContext = SSLContext.getInstance(sslContextProtocol);
            KeyManager[] keyManagers = HttpClient.keyManagers(this.env, keyStore, keyStorePassword, keyStoreAlgorithm, keyPassword);
            TrustManager[] trustManagers = HttpClient.trustManagers(this.env, trustStore, trustStorePassword, trustStoreAlgorithm);
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("http client failed to initialize the SSLContext", e);
        }
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    private static KeyManager[] keyManagers(Environment env, String keyStore, String keyStorePassword, String keyStoreAlgorithm, String keyPassword) {
        if (keyStore == null) {
            return null;
        }
        Path path = env.binFile().getParent().resolve(keyStore);
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        try {
            KeyStore ks = HttpClient.readKeystore(path, keyStorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyStoreAlgorithm);
            kmf.init(ks, keyPassword.toCharArray());
            return kmf.getKeyManagers();
        }
        catch (Exception e) {
            throw new RuntimeException("http client failed to initialize a KeyManagerFactory", e);
        }
    }

    private static TrustManager[] trustManagers(Environment env, String trustStore, String trustStorePassword, String trustStoreAlgorithm) {
        try {
            Path trustStorePath;
            KeyStore ks = null;
            if (trustStore != null && Files.exists(trustStorePath = env.binFile().getParent().resolve(trustStore), new LinkOption[0])) {
                ks = HttpClient.readKeystore(trustStorePath, trustStorePassword);
            }
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustStoreAlgorithm);
            trustFactory.init(ks);
            return trustFactory.getTrustManagers();
        }
        catch (Exception e) {
            throw new RuntimeException("http client failed to initialize a TrustManagerFactory", e);
        }
    }

    private static KeyStore readKeystore(Path path, String password) throws Exception {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance("jks");
            assert (password != null);
            ks.load(in, password.toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
    }
}

