/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.support;

import com.google.common.base.Equivalence;
import java.io.IOException;
import java.util.Arrays;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.watcher.support.Exceptions;

public final class SearchRequestEquivalence
extends Equivalence<SearchRequest> {
    public static final SearchRequestEquivalence INSTANCE = new SearchRequestEquivalence();

    private SearchRequestEquivalence() {
    }

    protected boolean doEquivalent(SearchRequest r1, SearchRequest r2) {
        try {
            BytesStreamOutput output1 = new BytesStreamOutput();
            r1.writeTo((StreamOutput)output1);
            byte[] bytes1 = output1.bytes().toBytes();
            output1.reset();
            r2.writeTo((StreamOutput)output1);
            byte[] bytes2 = output1.bytes().toBytes();
            return Arrays.equals(bytes1, bytes2);
        }
        catch (Throwable t) {
            throw Exceptions.illegalState("could not compare search requests", t, new Object[0]);
        }
    }

    protected int doHash(SearchRequest request) {
        try {
            BytesStreamOutput output = new BytesStreamOutput();
            request.writeTo((StreamOutput)output);
            return Arrays.hashCode(output.bytes().toBytes());
        }
        catch (IOException ioe) {
            throw Exceptions.illegalState("could not compute hashcode for search request", ioe, new Object[0]);
        }
    }
}

