/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.shield;

import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.authz.Privilege;
import org.elasticsearch.watcher.shield.ShieldIntegration;
import org.elasticsearch.watcher.shield.WatcherSettingsFilter;
import org.elasticsearch.watcher.shield.WatcherUserHolder;

public class WatcherShieldModule
extends AbstractModule {
    private final ESLogger logger;
    private final boolean enabled;
    private final WatcherUserHolder userHolder;

    public WatcherShieldModule(Settings settings) {
        this.logger = Loggers.getLogger(WatcherShieldModule.class, (Settings)settings, (String[])new String[0]);
        this.enabled = ShieldIntegration.enabled(settings);
        if (this.enabled) {
            this.userHolder = new WatcherUserHolder();
            this.registerClusterPrivilege("manage_watcher", "cluster:admin/watcher/*", "cluster:monitor/watcher/*");
            this.registerClusterPrivilege("monitor_watcher", "cluster:monitor/watcher/*");
        } else {
            this.userHolder = null;
        }
    }

    void registerClusterPrivilege(String name, String ... patterns) {
        try {
            Privilege.Cluster.addCustom((String)name, (String[])patterns);
        }
        catch (Exception se) {
            this.logger.warn("could not register cluster privilege [{}]", new Object[]{name});
        }
    }

    protected void configure() {
        this.bind(ShieldIntegration.class).asEagerSingleton();
        this.bind(WatcherUserHolder.class).toProvider(Providers.of((Object)this.userHolder));
        if (this.enabled) {
            this.bind(WatcherSettingsFilter.Shield.class).asEagerSingleton();
            this.bind(WatcherSettingsFilter.class).to(WatcherSettingsFilter.Shield.class);
        } else {
            this.bind(WatcherSettingsFilter.class).toInstance((Object)WatcherSettingsFilter.Noop.INSTANCE);
        }
    }
}

