/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.shield;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.shield.ShieldPlugin;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.authc.AuthenticationService;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.watcher.shield.WatcherUserHolder;

public class ShieldIntegration {
    private static final int MIN_SHIELD_VERSION = 2000001;
    private final Object authcService;
    private final Object userHolder;
    private final Object settingsFilter;

    @Inject
    public ShieldIntegration(Settings settings, Injector injector) {
        boolean enabled = ShieldIntegration.enabled(settings);
        this.authcService = enabled ? (AuthenticationService)injector.getInstance(AuthenticationService.class) : null;
        this.userHolder = enabled ? (WatcherUserHolder)injector.getInstance(WatcherUserHolder.class) : null;
        this.settingsFilter = enabled ? (ShieldSettingsFilter)injector.getInstance(ShieldSettingsFilter.class) : null;
    }

    public void bindWatcherUser(TransportMessage message) {
        if (this.authcService != null) {
            try {
                ((AuthenticationService)this.authcService).attachUserHeaderIfMissing((ContextAndHeaderHolder)message, ((WatcherUserHolder)this.userHolder).user);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to attach watcher user to request", (Throwable)e, new Object[0]);
            }
        }
    }

    public void filterOutSettings(String ... patterns) {
        if (this.settingsFilter != null) {
            ((ShieldSettingsFilter)this.settingsFilter).filterOut(patterns);
        }
    }

    public void putUserInContext(HasContext context) {
        if (this.userHolder != null) {
            context.putInContext((Object)"_shield_user", (Object)((WatcherUserHolder)this.userHolder).user);
        }
    }

    static boolean installed() {
        try {
            ShieldIntegration.class.getClassLoader().loadClass("org.elasticsearch.shield.ShieldPlugin");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean enabled(Settings settings) {
        return ShieldIntegration.installed() && ShieldPlugin.shieldEnabled((Settings)settings);
    }
}

