/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;
import org.elasticsearch.watcher.transport.actions.put.PutWatchRequest;
import org.elasticsearch.watcher.transport.actions.put.PutWatchResponse;

public class RestPutWatchAction
extends WatcherRestHandler {
    @Inject
    public RestPutWatchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}", (RestHandler)this);
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
        PutWatchRequest putWatchRequest = new PutWatchRequest(request.param("id"), request.content());
        putWatchRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putWatchRequest.masterNodeTimeout()));
        putWatchRequest.setActive(request.paramAsBoolean("active", putWatchRequest.isActive()));
        client.putWatch(putWatchRequest, (ActionListener<PutWatchResponse>)new RestBuilderListener<PutWatchResponse>(channel){

            public RestResponse buildResponse(PutWatchResponse response, XContentBuilder builder) throws Exception {
                builder.startObject().field("_id", response.getId()).field("_version", response.getVersion()).field("created", response.isCreated()).endObject();
                RestStatus status = response.isCreated() ? RestStatus.CREATED : RestStatus.OK;
                return new BytesRestResponse(status, builder);
            }
        });
    }
}

