/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.rest.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.watcher.client.WatcherClient;
import org.elasticsearch.watcher.rest.WatcherRestHandler;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.watcher.watch.Watch;

public class RestActivateWatchAction
extends WatcherRestHandler {
    @Inject
    public RestActivateWatchAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_activate", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_activate", (RestHandler)this);
        DeactivateRestHandler deactivateRestHandler = new DeactivateRestHandler(settings, controller, client);
        controller.registerHandler(RestRequest.Method.PUT, URI_BASE + "/watch/{id}/_deactivate", (RestHandler)deactivateRestHandler);
        controller.registerHandler(RestRequest.Method.POST, URI_BASE + "/watch/{id}/_deactivate", (RestHandler)deactivateRestHandler);
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
        String watchId = request.param("id");
        client.activateWatch(new ActivateWatchRequest(watchId, true), (ActionListener<ActivateWatchResponse>)new RestBuilderListener<ActivateWatchResponse>(channel){

            public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(RestStatus.OK, builder.startObject().field(Watch.Field.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
            }
        });
    }

    static class DeactivateRestHandler
    extends WatcherRestHandler {
        public DeactivateRestHandler(Settings settings, RestController controller, Client client) {
            super(settings, controller, client);
        }

        @Override
        protected void handleRequest(RestRequest request, RestChannel channel, WatcherClient client) throws Exception {
            String watchId = request.param("id");
            client.activateWatch(new ActivateWatchRequest(watchId, false), (ActionListener<ActivateWatchResponse>)new RestBuilderListener<ActivateWatchResponse>(channel){

                public RestResponse buildResponse(ActivateWatchResponse response, XContentBuilder builder) throws Exception {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().field(Watch.Field.STATUS.getPreferredName(), (ToXContent)response.getStatus(), (ToXContent.Params)WatcherParams.HIDE_SECRETS).endObject());
                }
            });
        }
    }
}

