/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.search;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.InputFactory;
import org.elasticsearch.watcher.input.search.ExecutableSearchInput;
import org.elasticsearch.watcher.input.search.SearchInput;
import org.elasticsearch.watcher.input.simple.ExecutableSimpleInput;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;

public class SearchInputFactory
extends InputFactory<SearchInput, SearchInput.Result, ExecutableSearchInput> {
    private final ClientProxy client;
    private final TimeValue defaultTimeout;

    @Inject
    public SearchInputFactory(Settings settings, ClientProxy client) {
        super(Loggers.getLogger(ExecutableSimpleInput.class, (Settings)settings, (String[])new String[0]));
        this.client = client;
        this.defaultTimeout = settings.getAsTime("watcher.input.search.default_timeout", null);
    }

    @Override
    public String type() {
        return "search";
    }

    @Override
    public SearchInput parseInput(String watchId, XContentParser parser) throws IOException {
        return SearchInput.parse(watchId, parser);
    }

    @Override
    public ExecutableSearchInput createExecutable(SearchInput input) {
        return new ExecutableSearchInput(input, this.inputLogger, this.client, this.defaultTimeout);
    }
}

