/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.search;

import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.input.search.SearchInput;
import org.elasticsearch.watcher.support.WatcherUtils;
import org.elasticsearch.watcher.support.XContentFilterKeysUtils;
import org.elasticsearch.watcher.support.init.proxy.ClientProxy;
import org.elasticsearch.watcher.watch.Payload;

public class ExecutableSearchInput
extends ExecutableInput<SearchInput, SearchInput.Result> {
    public static final SearchType DEFAULT_SEARCH_TYPE = SearchType.QUERY_THEN_FETCH;
    private final ClientProxy client;
    @Nullable
    private final TimeValue timeout;

    public ExecutableSearchInput(SearchInput input, ESLogger logger, ClientProxy client, @Nullable TimeValue defaultTimeout) {
        super(input, logger);
        this.client = client;
        this.timeout = input.getTimeout() != null ? input.getTimeout() : defaultTimeout;
    }

    @Override
    public SearchInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        SearchRequest request = null;
        try {
            request = WatcherUtils.createSearchRequestFromPrototype(((SearchInput)this.input).getSearchRequest(), ctx, payload);
            return this.doExecute(ctx, request);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] input for [{}]", (Throwable)e, new Object[]{"search", ctx.watch()});
            return new SearchInput.Result(request, e);
        }
    }

    SearchInput.Result doExecute(WatchExecutionContext ctx, SearchRequest request) throws Exception {
        Payload.Simple payload;
        if (this.logger.isTraceEnabled()) {
            BytesReference source = request.source() != null ? request.source() : request.templateSource();
            this.logger.trace("[{}] running query for [{}] [{}]", new Object[]{ctx.id(), ctx.watch().id(), XContentHelper.convertToJson((BytesReference)source, (boolean)false, (boolean)true)});
        }
        SearchResponse response = this.client.search(request, this.timeout);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("[{}] found [{}] hits", new Object[]{ctx.id(), response.getHits().getTotalHits()});
            for (SearchHit hit : response.getHits()) {
                this.logger.debug("[{}] hit [{}]", new Object[]{ctx.id(), XContentHelper.toString((ToXContent)hit)});
            }
        }
        if (((SearchInput)this.input).getExtractKeys() != null) {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject().value((Object)response).endObject();
            XContentParser parser = XContentHelper.createParser((BytesReference)builder.bytes());
            Map<String, Object> filteredKeys = XContentFilterKeysUtils.filterMapOrdered(((SearchInput)this.input).getExtractKeys(), parser);
            payload = new Payload.Simple(filteredKeys);
        } else {
            payload = new Payload.XContent((ToXContent)response);
        }
        return new SearchInput.Result(request, (Payload)payload);
    }
}

