/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input.chain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.Input;
import org.elasticsearch.watcher.input.InputRegistry;
import org.elasticsearch.watcher.watch.Payload;

public class ChainInput
implements Input {
    public static final String TYPE = "chain";
    private List<Tuple<String, Input>> inputs;

    public ChainInput(List<Tuple<String, Input>> inputs) {
        this.inputs = inputs;
    }

    @Override
    public String type() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("inputs");
        for (Tuple<String, Input> tuple : this.inputs) {
            builder.startObject().startObject((String)tuple.v1());
            builder.field(((Input)tuple.v2()).type(), (ToXContent)tuple.v2());
            builder.endObject().endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public List<Tuple<String, Input>> getInputs() {
        return this.inputs;
    }

    public static ChainInput parse(String watchId, XContentParser parser, InputRegistry inputRegistry) throws IOException {
        XContentParser.Token token;
        ArrayList<Tuple<String, Input>> inputs = new ArrayList<Tuple<String, Input>>();
        ParseField inputsField = new ParseField("inputs", new String[0]);
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token != XContentParser.Token.START_ARRAY || !inputsField.getPreferredName().equals(currentFieldName)) continue;
            String currentInputFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentInputFieldName = parser.currentName();
                    continue;
                }
                if (currentInputFieldName == null || token != XContentParser.Token.START_OBJECT) continue;
                inputs.add((Tuple<String, Input>)new Tuple((Object)currentInputFieldName, inputRegistry.parse(watchId, parser).input()));
                currentInputFieldName = null;
            }
        }
        return new ChainInput(inputs);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Result
    extends Input.Result {
        private List<Tuple<String, Input.Result>> results = Collections.emptyList();

        protected Result(List<Tuple<String, Input.Result>> results, Payload payload) {
            super(ChainInput.TYPE, payload);
            this.results = results;
        }

        protected Result(Exception e) {
            super(ChainInput.TYPE, e);
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(this.type);
            for (Tuple<String, Input.Result> tuple : this.results) {
                builder.field((String)tuple.v1(), (ToXContent)tuple.v2());
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Builder
    implements Input.Builder<ChainInput> {
        private List<Tuple<String, Input>> inputs = new ArrayList<Tuple<String, Input>>();

        private Builder() {
        }

        public Builder add(String name, Input.Builder input) {
            this.inputs.add((Tuple<String, Input>)new Tuple((Object)name, input.build()));
            return this;
        }

        @Override
        public ChainInput build() {
            return new ChainInput(this.inputs);
        }
    }
}

