/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.input;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.input.InputFactory;

public class InputRegistry {
    private final ImmutableMap<String, InputFactory> factories;

    @Inject
    public InputRegistry(Map<String, InputFactory> factories) {
        this.factories = ImmutableMap.copyOf(factories);
    }

    public ExecutableInput parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        String type = null;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse input for watch [{}]. expected an object representing the input, but found [{}] instead", new Object[]{watchId, parser.currentToken()});
        }
        ExecutableInput input = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                type = parser.currentName();
                continue;
            }
            if (type == null) {
                throw new ElasticsearchParseException("could not parse input for watch [{}]. expected field indicating the input type, but found [{}] instead", new Object[]{watchId, token});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                InputFactory factory = (InputFactory)this.factories.get((Object)type);
                if (factory == null) {
                    throw new ElasticsearchParseException("could not parse input for watch [{}]. unknown input type [{}]", new Object[]{watchId, type});
                }
                input = (ExecutableInput)factory.parseExecutable(watchId, parser);
                continue;
            }
            throw new ElasticsearchParseException("could not parse input for watch [{}]. expected an object representing input [{}], but found [{}] instead", new Object[]{watchId, type, token});
        }
        if (input == null) {
            throw new ElasticsearchParseException("could not parse input for watch [{}]. expected field indicating the input type, but found an empty object instead", new Object[]{watchId, token});
        }
        return input;
    }

    public Map<String, InputFactory> factories() {
        return this.factories;
    }
}

