/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.history;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.execution.ExecutionState;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.execution.WatchExecutionResult;
import org.elasticsearch.watcher.execution.Wid;
import org.elasticsearch.watcher.input.ExecutableInput;
import org.elasticsearch.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.watcher.trigger.TriggerEvent;
import org.elasticsearch.watcher.watch.Watch;

public class WatchRecord
implements ToXContent {
    private final Wid id;
    private final TriggerEvent triggerEvent;
    private final ExecutionState state;
    private final Map<String, Object> vars;
    @Nullable
    private final ExecutableInput input;
    @Nullable
    private final Condition condition;
    @Nullable
    private final Map<String, Object> metadata;
    @Nullable
    private final String[] messages;
    @Nullable
    private final WatchExecutionResult executionResult;

    public WatchRecord(Wid id, TriggerEvent triggerEvent, ExecutionState state, String message) {
        this.id = id;
        this.triggerEvent = triggerEvent;
        this.state = state;
        this.messages = new String[]{message};
        this.vars = Collections.emptyMap();
        this.executionResult = null;
        this.condition = null;
        this.input = null;
        this.metadata = null;
    }

    public WatchRecord(WatchExecutionContext context, WatchExecutionResult executionResult, String message) {
        this.id = context.id();
        this.triggerEvent = context.triggerEvent();
        this.state = ExecutionState.FAILED;
        this.messages = new String[]{message};
        this.vars = context.vars();
        this.executionResult = executionResult;
        this.condition = context.watch().condition().condition();
        this.input = context.watch().input();
        this.metadata = context.watch().metadata();
    }

    public WatchRecord(WatchExecutionContext context, WatchExecutionResult executionResult) {
        this.id = context.id();
        this.triggerEvent = context.triggerEvent();
        this.messages = Strings.EMPTY_ARRAY;
        this.vars = context.vars();
        this.executionResult = executionResult;
        this.condition = context.watch().condition().condition();
        this.input = context.watch().input();
        this.metadata = context.watch().metadata();
        this.state = !this.executionResult.conditionResult().met() ? ExecutionState.EXECUTION_NOT_NEEDED : (this.executionResult.actionsResults().throttled() ? ExecutionState.THROTTLED : ExecutionState.EXECUTED);
    }

    public WatchRecord(WatchRecord record, ExecutionState state, String message) {
        this.id = record.id;
        this.triggerEvent = record.triggerEvent;
        this.vars = record.vars;
        this.executionResult = record.executionResult;
        this.condition = record.condition;
        this.input = record.input;
        this.metadata = record.metadata;
        this.state = state;
        if (record.messages.length == 0) {
            this.messages = new String[]{message};
        } else {
            String[] newMessages = new String[record.messages.length + 1];
            System.arraycopy(record.messages, 0, newMessages, 0, record.messages.length);
            newMessages[record.messages.length] = message;
            this.messages = newMessages;
        }
    }

    public Wid id() {
        return this.id;
    }

    public TriggerEvent triggerEvent() {
        return this.triggerEvent;
    }

    public String watchId() {
        return this.id.watchId();
    }

    public ExecutableInput input() {
        return this.input;
    }

    public Condition condition() {
        return this.condition;
    }

    public ExecutionState state() {
        return this.state;
    }

    public String[] messages() {
        return this.messages;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    public WatchExecutionResult result() {
        return this.executionResult;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Field.WATCH_ID.getPreferredName(), this.id.watchId());
        builder.field(Field.STATE.getPreferredName(), this.state.id());
        builder.field(Field.TRIGGER_EVENT.getPreferredName());
        this.triggerEvent.recordXContent(builder, params);
        if (!this.vars.isEmpty() && WatcherParams.debug(params)) {
            builder.field(Field.VARS.getPreferredName(), this.vars);
        }
        if (this.input != null) {
            builder.startObject(Watch.Field.INPUT.getPreferredName()).field(this.input.type(), (ToXContent)this.input, params).endObject();
        }
        if (this.condition != null) {
            builder.startObject(Watch.Field.CONDITION.getPreferredName()).field(this.condition.type(), (ToXContent)this.condition, params).endObject();
        }
        if (this.messages != null) {
            builder.field(Field.MESSAGES.getPreferredName(), this.messages);
        }
        if (this.metadata != null) {
            builder.field(Field.METADATA.getPreferredName(), this.metadata);
        }
        if (this.executionResult != null) {
            builder.field(Field.EXECUTION_RESULT.getPreferredName(), (ToXContent)this.executionResult, params);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchRecord entry = (WatchRecord)o;
        return this.id.equals(entry.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.id.toString();
    }

    public static interface Field {
        public static final ParseField WATCH_ID = new ParseField("watch_id", new String[0]);
        public static final ParseField TRIGGER_EVENT = new ParseField("trigger_event", new String[0]);
        public static final ParseField MESSAGES = new ParseField("messages", new String[0]);
        public static final ParseField STATE = new ParseField("state", new String[0]);
        public static final ParseField VARS = new ParseField("vars", new String[0]);
        public static final ParseField METADATA = new ParseField("metadata", new String[0]);
        public static final ParseField EXECUTION_RESULT = new ParseField("result", new String[0]);
    }
}

