/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.script;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.support.Script;

public class ScriptCondition
implements Condition {
    public static final String TYPE = "script";
    final Script script;

    public ScriptCondition(Script script) {
        this.script = script;
    }

    @Override
    public final String type() {
        return TYPE;
    }

    public Script getScript() {
        return this.script;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.script.toXContent(builder, params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptCondition condition = (ScriptCondition)o;
        return this.script.equals(condition.script);
    }

    public int hashCode() {
        return this.script.hashCode();
    }

    public static ScriptCondition parse(String watchId, XContentParser parser) throws IOException {
        try {
            Script script = Script.parse(parser);
            return new ScriptCondition(script);
        }
        catch (ElasticsearchParseException pe) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. failed to parse script", (Throwable)pe, new Object[]{TYPE, watchId});
        }
    }

    public static Builder builder(Script script) {
        return new Builder(script);
    }

    public static class Builder
    implements Condition.Builder<ScriptCondition> {
        private final Script script;

        private Builder(Script script) {
            this.script = script;
        }

        @Override
        public ScriptCondition build() {
            return new ScriptCondition(this.script);
        }
    }

    public static class Result
    extends Condition.Result {
        static final Result MET = new Result(true);
        static final Result UNMET = new Result(false);

        private Result(boolean met) {
            super(ScriptCondition.TYPE, met);
        }

        Result(Exception e) {
            super(ScriptCondition.TYPE, e);
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

