/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.script;

import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.watcher.condition.ExecutableCondition;
import org.elasticsearch.watcher.condition.script.ScriptCondition;
import org.elasticsearch.watcher.execution.WatchExecutionContext;
import org.elasticsearch.watcher.support.Exceptions;
import org.elasticsearch.watcher.support.Variables;
import org.elasticsearch.watcher.support.init.proxy.ScriptServiceProxy;

public class ExecutableScriptCondition
extends ExecutableCondition<ScriptCondition, ScriptCondition.Result> {
    private final ScriptServiceProxy scriptService;
    private final CompiledScript compiledScript;

    public ExecutableScriptCondition(ScriptCondition condition, ESLogger logger, ScriptServiceProxy scriptService) {
        super(condition, logger);
        this.scriptService = scriptService;
        try {
            this.compiledScript = scriptService.compile(condition.script);
        }
        catch (Exception e) {
            throw Exceptions.invalidScript("failed to compile script [{}] with lang [{}] of type [{}]", e, condition.script.script(), condition.script.lang(), condition.script.type(), e);
        }
    }

    @Override
    public ScriptCondition.Result execute(WatchExecutionContext ctx) {
        try {
            return this.doExecute(ctx);
        }
        catch (Exception e) {
            this.logger.error("failed to execute [{}] condition for [{}]", (Throwable)e, new Object[]{"script", ctx.id()});
            return new ScriptCondition.Result(e);
        }
    }

    public ScriptCondition.Result doExecute(WatchExecutionContext ctx) throws Exception {
        ExecutableScript executable;
        Object value;
        Map<String, Object> parameters = Variables.createCtxModel(ctx, ctx.payload());
        if (((ScriptCondition)this.condition).script.params() != null && !((ScriptCondition)this.condition).script.params().isEmpty()) {
            parameters.putAll(((ScriptCondition)this.condition).script.params());
        }
        if ((value = (executable = this.scriptService.executable(this.compiledScript, parameters)).run()) instanceof Boolean) {
            return (Boolean)value != false ? ScriptCondition.Result.MET : ScriptCondition.Result.UNMET;
        }
        throw Exceptions.invalidScript("condition [{}] must return a boolean value (true|false) but instead returned [{}]", this.type(), ctx.watch().id(), ((ScriptCondition)this.condition).script.script(), value);
    }
}

