/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.compare.array;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.watcher.condition.compare.AbstractExecutableCompareCondition;
import org.elasticsearch.watcher.condition.compare.array.ArrayCompareCondition;
import org.elasticsearch.watcher.support.clock.Clock;
import org.elasticsearch.watcher.support.xcontent.ObjectPath;

public class ExecutableArrayCompareCondition
extends AbstractExecutableCompareCondition<ArrayCompareCondition, ArrayCompareCondition.Result> {
    public ExecutableArrayCompareCondition(ArrayCompareCondition condition, ESLogger logger, Clock clock) {
        super(condition, logger, clock);
    }

    @Override
    public ArrayCompareCondition.Result doExecute(Map<String, Object> model, Map<String, Object> resolvedValues) throws Exception {
        Object configuredValue = this.resolveConfiguredValue(resolvedValues, model, ((ArrayCompareCondition)this.condition).getValue());
        Object object = ObjectPath.eval(((ArrayCompareCondition)this.condition).getArrayPath(), model);
        if (object != null && !(object instanceof List)) {
            throw new IllegalStateException("array path " + ((ArrayCompareCondition)this.condition).getArrayPath() + " did not evaluate to array, was " + object);
        }
        List resolvedArray = object != null ? (List)object : Collections.emptyList();
        ArrayList<Object> resolvedValue = new ArrayList<Object>(resolvedArray.size());
        for (int i = 0; i < resolvedArray.size(); ++i) {
            resolvedValue.add(ObjectPath.eval(((ArrayCompareCondition)this.condition).getPath(), resolvedArray.get(i)));
        }
        resolvedValues.put(((ArrayCompareCondition)this.condition).getArrayPath(), resolvedArray);
        return new ArrayCompareCondition.Result(resolvedValues, ((ArrayCompareCondition)this.condition).getQuantifier().eval(resolvedValue, configuredValue, ((ArrayCompareCondition)this.condition).getOp()));
    }

    @Override
    protected ArrayCompareCondition.Result doFailure(Map<String, Object> resolvedValues, Exception e) {
        return new ArrayCompareCondition.Result(resolvedValues, e);
    }
}

