/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher.condition.compare;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.watcher.condition.Condition;
import org.elasticsearch.watcher.condition.compare.LenientCompare;
import org.elasticsearch.watcher.support.xcontent.WatcherXContentUtils;

public class CompareCondition
implements Condition {
    public static final String TYPE = "compare";
    private String path;
    private Op op;
    private Object value;

    public CompareCondition(String path, Op op, Object value) {
        this.path = path;
        this.op = op;
        this.value = value;
    }

    @Override
    public final String type() {
        return TYPE;
    }

    public String getPath() {
        return this.path;
    }

    public Op getOp() {
        return this.op;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareCondition condition = (CompareCondition)o;
        if (!this.path.equals(condition.path)) {
            return false;
        }
        if (this.op != condition.op) {
            return false;
        }
        return !(this.value == null ? condition.value != null : !this.value.equals(condition.value));
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.op.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().startObject(this.path).field(this.op.id(), this.value).endObject().endObject();
    }

    public static CompareCondition parse(String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        String path = null;
        Object value = null;
        Op op = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                path = parser.currentName();
                continue;
            }
            if (path == null) {
                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the compared path, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                token = parser.nextToken();
                if (token != XContentParser.Token.FIELD_NAME) {
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the comparison operator, but found [{}] instead", new Object[]{TYPE, watchId, token});
                }
                try {
                    op = Op.resolve(parser.currentName());
                }
                catch (IllegalArgumentException iae) {
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. unknown comparison operator [{}]", new Object[]{TYPE, watchId, parser.currentName()});
                }
                token = parser.nextToken();
                if (!op.supportsStructures() && !token.isValue() && token != XContentParser.Token.VALUE_NULL) {
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. compared value for [{}] with operation [{}] must either be a numeric, string, boolean or null value, but found [{}] instead", new Object[]{TYPE, watchId, path, op.name().toLowerCase(Locale.ROOT), token});
                }
                value = WatcherXContentUtils.readValue(parser, token);
                token = parser.nextToken();
                if (token == XContentParser.Token.END_OBJECT) continue;
                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected end of path object, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object for field [{}] but found [{}] instead", new Object[]{TYPE, watchId, path, token});
        }
        return new CompareCondition(path, op, value);
    }

    public static Builder builder(String path, Op op, Object value) {
        return new Builder(path, op, value);
    }

    static interface Field
    extends Condition.Field {
        public static final ParseField RESOLVED_VALUES = new ParseField("resolved_values", new String[0]);
    }

    public static class Builder
    implements Condition.Builder<CompareCondition> {
        private String path;
        private Op op;
        private Object value;

        public Builder(String path, Op op, Object value) {
            this.path = path;
            this.op = op;
            this.value = value;
        }

        @Override
        public CompareCondition build() {
            return new CompareCondition(this.path, this.op, this.value);
        }
    }

    public static enum Op {
        EQ{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal == 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        NOT_EQ{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal == null || compVal != 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        LT{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal < 0;
            }
        }
        ,
        LTE{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal <= 0;
            }
        }
        ,
        GT{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal > 0;
            }
        }
        ,
        GTE{

            @Override
            public boolean eval(Object v1, Object v2) {
                Integer compVal = LenientCompare.compare(v1, v2);
                return compVal != null && compVal >= 0;
            }
        };


        public abstract boolean eval(Object var1, Object var2);

        public boolean supportsStructures() {
            return false;
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Op resolve(String id) {
            return Op.valueOf(id.toUpperCase(Locale.ROOT));
        }
    }

    public static class Result
    extends Condition.Result {
        @Nullable
        private final Map<String, Object> resolveValues;

        Result(Map<String, Object> resolveValues, boolean met) {
            super(CompareCondition.TYPE, met);
            this.resolveValues = resolveValues;
        }

        Result(@Nullable Map<String, Object> resolvedValues, Exception e) {
            super(CompareCondition.TYPE, e);
            this.resolveValues = resolvedValues;
        }

        public Map<String, Object> getResolveValues() {
            return this.resolveValues;
        }

        @Override
        protected XContentBuilder typeXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.resolveValues == null) {
                return builder;
            }
            return builder.startObject(this.type).field(Field.RESOLVED_VALUES.getPreferredName(), this.resolveValues).endObject();
        }
    }
}

